/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.resourcetype.FluidResourceType;
import ca.teamdman.sfm.common.resourcetype.ForgeEnergyResourceType;
import ca.teamdman.sfm.common.resourcetype.ItemResourceType;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class SFMResourceTypes {
    public static final ResourceLocation REGISTRY_ID = new ResourceLocation("sfm", "resource_type");
    private static final DeferredRegister<ResourceType<?, ?, ?>> TYPES = DeferredRegister.create((ResourceLocation)REGISTRY_ID, (String)"sfm");
    public static final Supplier<IForgeRegistry<ResourceType<?, ?, ?>>> DEFERRED_TYPES = TYPES.makeRegistry(() -> new RegistryBuilder().setName(REGISTRY_ID));
    public static final RegistryObject<ResourceType<ItemStack, Item, IItemHandler>> ITEM = TYPES.register("item", ItemResourceType::new);
    public static final RegistryObject<ResourceType<FluidStack, Fluid, IFluidHandler>> FLUID = TYPES.register("fluid", FluidResourceType::new);
    public static final RegistryObject<ResourceType<Integer, Class<Integer>, IEnergyStorage>> FORGE_ENERGY = TYPES.register("forge_energy", ForgeEnergyResourceType::new);
    private static final Object2ObjectOpenHashMap<ResourceLocation, ResourceType<?, ?, ?>> DEFERRED_TYPES_BY_ID = new Object2ObjectOpenHashMap();

    public static int getResourceTypeCount() {
        return TYPES.getEntries().size();
    }

    @Nullable
    public static ResourceType<?, ?, ?> fastLookup(ResourceLocation resourceTypeId) {
        return (ResourceType)DEFERRED_TYPES_BY_ID.computeIfAbsent((Object)resourceTypeId, i -> (ResourceType)DEFERRED_TYPES.get().getValue(resourceTypeId));
    }

    public static Stream<Capability<?>> getCapabilities() {
        return TYPES.getEntries().stream().map(RegistryObject::get).map(resourceType -> resourceType.CAPABILITY_KIND);
    }

    public static void register(IEventBus bus) {
        TYPES.register(bus);
    }

    static {
        if (SFMModCompat.isMekanismLoaded()) {
            SFMMekanismCompat.registerResourceTypes(TYPES);
        }
    }
}

