/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.linting.GatherWarningsProgramBehaviour;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.RoundRobin;
import java.util.ArrayList;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FlowProgramLinter
implements IProgramLinter {
    @Override
    public ArrayList<TranslatableContents> gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity managerBlockEntity) {
        ArrayList<TranslatableContents> warnings = new ArrayList<TranslatableContents>();
        this.addWarningsForUsingIOWithoutCorrespondingOppositeIO(program, labelPositionHolder, warnings);
        program.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).forEach(statement -> {
            this.addWarningsForSmellyRoundRobinUsage(warnings, (IOStatement)statement);
            this.addWarningsForUsingEachWithoutAPattern(warnings, (IOStatement)statement);
        });
        return warnings;
    }

    @Override
    public void fixWarnings(ManagerBlockEntity managerBlockEntity, ItemStack diskStack, Program program) {
    }

    private void addWarningsForUsingIOWithoutCorrespondingOppositeIO(Program program, LabelPositionHolder labelPositionHolder, ArrayList<TranslatableContents> warnings) {
        program.tick(ProgramContext.createSimulationContext(program, labelPositionHolder, 0, new GatherWarningsProgramBehaviour(warnings::addAll)));
    }

    private void addWarningsForUsingEachWithoutAPattern(ArrayList<TranslatableContents> warnings, IOStatement statement) {
        boolean smells = statement.resourceLimits().resourceLimitList().stream().anyMatch(rl -> rl.limit().quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND && !rl.resourceIds().couldMatchMoreThanOne());
        if (smells) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_RESOURCE_EACH_WITHOUT_PATTERN.get(statement.toStringPretty()));
        }
    }

    private void addWarningsForSmellyRoundRobinUsage(ArrayList<TranslatableContents> warnings, IOStatement statement) {
        RoundRobin roundRobin = statement.labelAccess().roundRobin();
        if (roundRobin.getBehaviour() == RoundRobin.Behaviour.BY_BLOCK && statement.each()) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_ROUND_ROBIN_SMELLY_EACH.get(statement.toStringPretty()));
        } else if (roundRobin.getBehaviour() == RoundRobin.Behaviour.BY_LABEL && statement.labelAccess().labels().size() == 1) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_ROUND_ROBIN_SMELLY_COUNT.get(statement.toStringPretty()));
        }
    }
}

