/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class ClientRecipeHelper {
    private ClientRecipeHelper() {
    }

    public static Optional<? extends Recipe<?>> getRecipeByKey(ResourceLocation recipeKey) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        if (world == null) {
            return Optional.empty();
        }
        return world.m_7465_().m_44043_(recipeKey);
    }

    public static <T extends Recipe<?>, U extends Recipe<?>> List<T> getAndTransformAvailableRecipes(Set<ResourceLocation> recipeKeys, Class<U> originalRecipeClass, Function<U, T> transformRecipe) {
        ArrayList ret = new ArrayList();
        recipeKeys.forEach(key -> ClientRecipeHelper.getRecipeByKey(key).ifPresent(r -> {
            if (originalRecipeClass.isInstance(r)) {
                ret.add((Recipe)transformRecipe.apply((Recipe)originalRecipeClass.cast(r)));
            }
        }));
        return ret;
    }

    public static <T extends Recipe<?>, U extends Recipe<?>> List<T> getAndTransformAvailableItemGroupRecipes(Set<ResourceLocation> recipeKeys, Class<U> originalRecipeClass, Function<U, List<T>> getTransformedRecipes) {
        ArrayList ret = new ArrayList();
        recipeKeys.forEach(key -> ClientRecipeHelper.getRecipeByKey(key).ifPresent(r -> {
            if (originalRecipeClass.isInstance(r)) {
                ret.addAll((Collection)getTransformedRecipes.apply((Recipe)originalRecipeClass.cast(r)));
            }
        }));
        return ret;
    }

    public static CraftingRecipe copyShapedRecipe(ShapedRecipe recipe) {
        return new ShapedRecipe(recipe.m_6423_(), "", recipe.getRecipeWidth(), recipe.getRecipeHeight(), recipe.m_7527_(), recipe.m_8043_());
    }
}

