/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import sc_libs.org.jetbrains.annotations.NotNull;
import sc_libs.org.jetbrains.annotations.Nullable;

public class ChunkManager {
    @NotNull
    public static Holder<Biome> getRoughBiome(Level level, BlockPos pos) {
        ChunkAccess chunk = ChunkManager.getChunkNow((LevelReader)level, pos);
        int x = pos.m_123341_() >> 2;
        int y = pos.m_123342_() >> 2;
        int z = pos.m_123343_() >> 2;
        return chunk != null ? chunk.m_203495_(x, y, z) : level.m_203675_(x, y, z);
    }

    @NotNull
    public static BlockState getBlockState(Level level, BlockPos pos) {
        ChunkAccess chunk = ChunkManager.getChunkNow((LevelReader)level, pos);
        return chunk != null ? chunk.m_8055_(pos) : Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public static ChunkAccess getChunkNow(LevelReader levelReader, BlockPos pos) {
        return ChunkManager.getChunkNow(levelReader, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    @Nullable
    public static ChunkAccess getChunkNow(LevelReader levelReader, int chunkX, int chunkZ) {
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            return ChunkManager.getChunkFromHolder(ChunkManager.getChunkHolder(level, chunkX, chunkZ));
        }
        return levelReader.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false);
    }

    @Nullable
    public static LevelChunk getChunkFromFuture(CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> chunkFuture) {
        Either either;
        if (chunkFuture == ChunkHolder.f_139998_ || (either = (Either)chunkFuture.getNow(null)) == null) {
            return null;
        }
        return either.left().orElse(null);
    }

    @Nullable
    public static LevelChunk getChunkFromHolder(ChunkHolder holder) {
        return holder != null ? ChunkManager.getChunkFromFuture(holder.m_140082_()) : null;
    }

    @Nullable
    private static ChunkHolder getChunkHolder(ServerLevel level, int chunkX, int chunkZ) {
        return level.m_7726_().m_8364_(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
    }

    public static boolean hasChunk(Level level, BlockPos pos) {
        return ChunkManager.hasChunk(level, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean hasChunk(Level level, int chunkX, int chunkZ) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return ChunkManager.hasChunk(ChunkManager.getChunkHolder(serverLevel, chunkX, chunkZ));
        }
        return true;
    }

    public static boolean hasChunk(ChunkHolder holder) {
        return ChunkManager.getChunkFromHolder(holder) != null;
    }

    public static void disableSpawnChunks(MinecraftServer server) {
        ServerLevel level = server.m_129783_();
        ChunkPos pos = new ChunkPos(new BlockPos(level.m_6106_().m_6789_(), 0, level.m_6106_().m_6526_()));
        level.m_7726_().m_8438_(TicketType.f_9442_, pos, 11, (Object)Unit.INSTANCE);
    }

    public static boolean areChunksLoadedForMove(ServerLevel level, AABB box) {
        int minBlockX = Mth.m_14107_((double)(box.f_82288_ - 1.0E-7)) - 3;
        int maxBlockX = Mth.m_14107_((double)(box.f_82291_ + 1.0E-7)) + 3;
        int minBlockZ = Mth.m_14107_((double)(box.f_82290_ - 1.0E-7)) - 3;
        int maxBlockZ = Mth.m_14107_((double)(box.f_82293_ + 1.0E-7)) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (ChunkManager.hasChunk((Level)level, chunkX, chunkZ)) continue;
                return false;
            }
        }
        return true;
    }
}

