/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import java.util.function.Function;
import me.wesley1808.servercore.common.ServerCore;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.ConfigEntry;
import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.interfaces.IMobCategory;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.utils.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class ServerCoreCommand {
    private static final String VALUE = "value";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder node = Commands.m_82127_((String)"servercore");
        node.then(ServerCoreCommand.config());
        node.then(ServerCoreCommand.settings());
        if (CommandConfig.COMMAND_STATUS.get().booleanValue()) {
            node.then(Commands.m_82127_((String)"status").executes(ctx -> ServerCoreCommand.getStatus((CommandSourceStack)ctx.getSource())));
        }
        dispatcher.register(node);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"sc").redirect((CommandNode)node.build()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> config() {
        LiteralArgumentBuilder config = (LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(Permission.require("command.config", 2));
        for (Config.Table table : Config.Table.values()) {
            LiteralArgumentBuilder child = Commands.m_82127_((String)table.key);
            try {
                Config.forEachEntry(table.clazz, (field, entry) -> {
                    String key = field.getName().toLowerCase();
                    Type type = ServerCoreCommand.getTypeFor(key, entry);
                    if (type != null) {
                        child.then(((LiteralArgumentBuilder)Commands.m_82127_((String)key).executes(ctx -> ServerCoreCommand.sendInfo((CommandSourceStack)ctx.getSource(), String.format("%s.%s", table.key, key), entry))).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)VALUE, type.argumentType).executes(type.function::apply)).suggests((ctx, suggestionsBuilder) -> Util.suggestAll(suggestionsBuilder, ServerCoreCommand.asString(entry.get()), ServerCoreCommand.asString(entry.getDefault())))));
                    }
                });
            }
            catch (Throwable throwable) {
                ServerCore.LOGGER.error("Exception thrown whilst registering commands!", throwable);
            }
            config.then((ArgumentBuilder)child);
        }
        if (Config.isConfigAvailable()) {
            config.then(Commands.m_82127_((String)"reload").executes(ctx -> ServerCoreCommand.saveOrReload((CommandSourceStack)ctx.getSource(), false)));
            config.then(Commands.m_82127_((String)"save").executes(ctx -> ServerCoreCommand.saveOrReload((CommandSourceStack)ctx.getSource(), true)));
        }
        return config;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> settings() {
        LiteralArgumentBuilder settings = (LiteralArgumentBuilder)Commands.m_82127_((String)"settings").requires(Permission.require("command.settings", 2));
        settings.then(Commands.m_82127_((String)"chunk_tick_distance").then(Commands.m_82129_((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)2, (int)128)).executes(ctx -> ServerCoreCommand.modify((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), 1, "Chunk-tick distance", false))));
        settings.then(Commands.m_82127_((String)"view_distance").then(Commands.m_82129_((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)2, (int)128)).executes(ctx -> ServerCoreCommand.modify((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), 2, "View distance", false))));
        settings.then(Commands.m_82127_((String)"simulation_distance").then(Commands.m_82129_((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)2, (int)128)).executes(ctx -> ServerCoreCommand.modify((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), 3, "Simulation distance", false))));
        settings.then(Commands.m_82127_((String)"mobcaps").then(Commands.m_82129_((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(ctx -> ServerCoreCommand.modify((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), 4, "Mobcaps", true))));
        return settings;
    }

    private static int sendInfo(CommandSourceStack source, String key, ConfigEntry<Object> entry) {
        String message = String.format("<dark_aqua>Key: <green>%s\n<dark_aqua>Current value: <green>%s\n<dark_aqua>Default value: <green>%s\n<dark_aqua>Type: <green>%s", key, ServerCoreCommand.asString(entry.get()), ServerCoreCommand.asString(entry.getDefault()), entry.getType().getSimpleName());
        source.m_81354_(Formatter.parse(message), false);
        return 1;
    }

    private static int modify(String key, ConfigEntry<Object> entry, Object value, CommandSourceStack source) {
        if (value instanceof String) {
            String val = (String)value;
            value = val.replace("#N", "\n");
        }
        ServerCoreCommand.sendMessage(source, key, String.valueOf(value), entry.set(value));
        IMobCategory.reload();
        return 1;
    }

    private static int modify(CommandSourceStack source, int value, int id, String setting, boolean percentage) {
        DynamicManager manager = DynamicManager.getInstance(source.m_81377_());
        switch (id) {
            case 1: {
                DynamicSetting.CHUNK_TICK_DISTANCE.set(value, manager);
                break;
            }
            case 2: {
                DynamicSetting.VIEW_DISTANCE.set(value, manager);
                break;
            }
            case 3: {
                DynamicSetting.SIMULATION_DISTANCE.set(value, manager);
                break;
            }
            case 4: {
                DynamicSetting.MOBCAP_MULTIPLIER.set((double)value / 100.0, manager);
            }
        }
        ServerCoreCommand.sendMessage(source, setting, value + (percentage ? "%" : ""), true);
        return 1;
    }

    private static int saveOrReload(CommandSourceStack source, boolean saved) {
        if (saved) {
            Config.save();
        } else {
            Config.load(true);
        }
        source.m_81354_((Component)Component.m_237113_((String)(saved ? "Config saved!" : "Config reloaded!")).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int getStatus(CommandSourceStack source) {
        Component component = Formatter.parse(DynamicManager.createStatusReport(Formatter.line(CommandConfig.STATUS_TITLE.get(), 40, source.m_230897_())));
        source.m_81354_(component, false);
        return 1;
    }

    private static void sendMessage(CommandSourceStack source, String key, String value, boolean success) {
        if (success) {
            source.m_81354_(Formatter.parse(String.format("<green>%s <dark_aqua>has been set to <green>%s", key, value)), false);
        } else {
            source.m_81352_((Component)Component.m_237113_((String)String.format("%s cannot be set to %s!", key, value)));
        }
    }

    private static Type getTypeFor(String key, ConfigEntry<Object> entry) {
        return switch (entry.getType().getSimpleName()) {
            case "Boolean" -> new Type((ArgumentType<?>)BoolArgumentType.bool(), ctx -> ServerCoreCommand.modify(key, entry, BoolArgumentType.getBool((CommandContext)ctx, (String)VALUE), (CommandSourceStack)ctx.getSource()));
            case "Integer" -> new Type((ArgumentType<?>)LongArgumentType.longArg((long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE), ctx -> ServerCoreCommand.modify(key, entry, (int)LongArgumentType.getLong((CommandContext)ctx, (String)VALUE), (CommandSourceStack)ctx.getSource()));
            case "Double" -> new Type((ArgumentType<?>)DoubleArgumentType.doubleArg(), ctx -> ServerCoreCommand.modify(key, entry, DoubleArgumentType.getDouble((CommandContext)ctx, (String)VALUE), (CommandSourceStack)ctx.getSource()));
            case "String" -> new Type((ArgumentType<?>)StringArgumentType.greedyString(), ctx -> ServerCoreCommand.modify(key, entry, StringArgumentType.getString((CommandContext)ctx, (String)VALUE), (CommandSourceStack)ctx.getSource()));
            default -> null;
        };
    }

    private static String asString(Object obj) {
        String string;
        if (obj instanceof String) {
            String string2 = (String)obj;
            string = string2.replace("\n", "#N");
        } else {
            string = String.valueOf(obj);
        }
        return string;
    }

    private record Type(ArgumentType<?> argumentType, Function<CommandContext<CommandSourceStack>, Integer> function) {
    }
}

