/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.activation_range;

import java.util.function.Predicate;
import me.wesley1808.servercore.common.activation_range.ActivationType;
import me.wesley1808.servercore.common.config.tables.ActivationRangeConfig;
import me.wesley1808.servercore.common.interfaces.activation_range.LevelInfo;
import me.wesley1808.servercore.common.utils.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ActivationRange {
    private static final Predicate<Goal> BEE_GOAL_IMMUNITIES = goal -> goal instanceof Bee.BeeGoToKnownFlowerGoal || goal instanceof Bee.BeeGoToHiveGoal;
    private static final Activity[] VILLAGER_PANIC_IMMUNITIES = new Activity[]{Activity.f_37987_, Activity.f_37986_, Activity.f_37985_, Activity.f_37984_};

    public static ActivationType initializeEntityActivationType(Entity entity) {
        if (entity instanceof Raider) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof WaterAnimal) {
            return ActivationType.WATER;
        }
        if (entity instanceof Villager) {
            return ActivationType.VILLAGER;
        }
        if (entity.m_6095_() == EntityType.f_20501_ || entity.m_6095_() == EntityType.f_20458_) {
            return ActivationType.ZOMBIE;
        }
        if (entity instanceof Creeper || entity instanceof Slime || entity instanceof Hoglin) {
            return ActivationType.MONSTER_BELOW;
        }
        if (entity instanceof FlyingMob) {
            return ActivationType.FLYING;
        }
        if (entity instanceof Enemy) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof AgeableMob || entity instanceof AmbientCreature) {
            return ActivationType.ANIMAL;
        }
        if (entity instanceof PathfinderMob) {
            return ActivationType.NEUTRAL;
        }
        return ActivationType.MISC;
    }

    public static boolean isExcluded(Entity entity) {
        return entity.getActivationType().activationRange.getAsInt() <= 0 || entity instanceof Player || entity instanceof ThrowableItemProjectile || entity instanceof EnderDragon || entity instanceof EnderDragonPart || entity instanceof WitherBoss || entity instanceof Fireball || entity instanceof LightningBolt || entity instanceof PrimedTnt || entity instanceof EndCrystal || entity instanceof FireworkRocketEntity || entity instanceof EyeOfEnder || entity instanceof ThrownTrident || entity instanceof Ghast || entity instanceof Warden || entity instanceof MinecartHopper;
    }

    public static void activateEntities(ServerLevel level) {
        int currentTick = level.m_7654_().m_129921_();
        int maxRange = Integer.MIN_VALUE;
        for (ActivationType type : ActivationType.values()) {
            maxRange = Math.max(type.activationRange.getAsInt(), maxRange);
        }
        LevelInfo info = (LevelInfo)level;
        for (ActivationType.Wakeup wakeup : ActivationType.Wakeup.values()) {
            info.setRemaining(wakeup, Math.min(info.getRemaining(wakeup) + 1, wakeup.max.getAsInt()));
        }
        maxRange = Math.min((level.m_7654_().m_6846_().m_11312_() << 4) - 8, maxRange);
        for (ServerPlayer player : level.m_6907_()) {
            AABB maxBB;
            if (player.m_5833_()) continue;
            if (ActivationRangeConfig.USE_VERTICAL_RANGE.get().booleanValue()) {
                maxBB = player.m_20191_().m_82377_((double)maxRange, 128.0, (double)maxRange);
                for (ActivationType type : ActivationType.values()) {
                    type.boundingBox = player.m_20191_().m_82400_((double)type.activationRange.getAsInt());
                    if (type.extraHeightUp) {
                        type.boundingBox = type.boundingBox.m_82363_(0.0, 96.0, 0.0);
                    }
                    if (!type.extraHeightDown) continue;
                    type.boundingBox = type.boundingBox.m_82363_(0.0, -96.0, 0.0);
                }
            } else {
                maxBB = player.m_20191_().m_82377_((double)maxRange, 256.0, (double)maxRange);
                for (ActivationType type : ActivationType.values()) {
                    int range = type.activationRange.getAsInt();
                    type.boundingBox = player.m_20191_().m_82377_((double)range, 256.0, (double)range);
                }
            }
            for (Entity entity : level.m_45933_((Entity)player, maxBB)) {
                ActivationRange.activateEntity(entity, currentTick);
            }
        }
    }

    private static void activateEntity(Entity entity, int currentTick) {
        if (currentTick > entity.getActivatedTick() && (entity.isExcluded() || entity.getActivationType().boundingBox.m_82381_(entity.m_20191_()))) {
            entity.setActivatedTick(currentTick + 19);
        }
    }

    public static int checkEntityImmunities(Entity entity, int currentTick) {
        int inactiveWakeUpImmunity = ActivationRange.checkInactiveWakeup(entity, currentTick);
        if (inactiveWakeUpImmunity > -1) {
            return inactiveWakeUpImmunity;
        }
        if (entity.m_20094_() > 0) {
            return 2;
        }
        if (entity.getActivatedImmunityTick() >= currentTick) {
            return 1;
        }
        if (!entity.m_6084_()) {
            return 40;
        }
        ActivationType type = entity.getActivationType();
        if (entity.m_20069_() && entity.m_6063_() && type != ActivationType.ANIMAL && type != ActivationType.FLYING && type != ActivationType.VILLAGER && type != ActivationType.WATER && !(entity instanceof Boat)) {
            return 100;
        }
        if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            Vec3 movement = entity.m_20184_();
            if (movement.f_82479_ != 0.0 || movement.f_82481_ != 0.0 || movement.f_82480_ > 0.0) {
                return 20;
            }
        }
        if (!(entity instanceof AbstractArrow)) {
            if (!(entity.m_20096_() || entity.m_20069_() || entity instanceof FlyingMob || entity instanceof Bat)) {
                return 10;
            }
        } else {
            AbstractArrow projectile = (AbstractArrow)entity;
            if (!projectile.f_36703_) {
                return 1;
            }
        }
        if (entity instanceof LivingEntity) {
            Creeper creeper;
            Llama llama;
            Mob mob;
            LivingEntity living = (LivingEntity)entity;
            if (living.f_20899_ || !living.m_21220_().isEmpty() || living.m_6147_()) {
                return 1;
            }
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() != null) {
                return 20;
            }
            if (entity instanceof Bee) {
                Bee bee = (Bee)entity;
                if (bee.f_27699_.m_28086_() || bee.m_21660_() || Util.hasTasks(bee.m_148772_(), BEE_GOAL_IMMUNITIES)) {
                    return 20;
                }
            }
            if (entity instanceof Villager) {
                int immunityAfter;
                Villager villager = (Villager)entity;
                Brain brain = villager.m_6274_();
                if (ActivationRangeConfig.VILLAGER_TICK_PANIC.get().booleanValue()) {
                    for (Activity activity : VILLAGER_PANIC_IMMUNITIES) {
                        if (!brain.m_21954_(activity)) continue;
                        return 100;
                    }
                }
                if ((immunityAfter = ActivationRangeConfig.VILLAGER_WORK_IMMUNITY_AFTER.get().intValue()) > 0 && currentTick - entity.getActivatedTick() >= immunityAfter && brain.m_21954_(Activity.f_37980_)) {
                    return ActivationRangeConfig.VILLAGER_WORK_IMMUNITY_FOR.get();
                }
            }
            if (entity instanceof Llama && (llama = (Llama)entity).m_30811_()) {
                return 1;
            }
            if (entity instanceof Animal) {
                Sheep sheep;
                Animal animal = (Animal)entity;
                if (animal.m_6162_() || animal.m_27593_()) {
                    return 5;
                }
                if (entity instanceof Sheep && (sheep = (Sheep)entity).m_29875_()) {
                    return 1;
                }
            }
            if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32311_()) {
                return 20;
            }
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                if (Util.hasTasks(mob.f_21346_)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    public static boolean checkIfActive(Entity entity, int currentTick) {
        boolean active;
        if (ActivationRange.shouldTick(entity)) {
            return true;
        }
        boolean bl = active = entity.getActivatedTick() >= currentTick;
        if (!active) {
            if ((currentTick - entity.getActivatedTick() - 1) % 20 == 0) {
                int immunity = ActivationRange.checkEntityImmunities(entity, currentTick);
                if (immunity >= 0) {
                    entity.setActivatedTick(currentTick + immunity);
                    return true;
                }
                return entity.getActivationType().tickInactive.getAsBoolean();
            }
        } else if (ActivationRangeConfig.SKIP_NON_IMMUNE.get().booleanValue() && entity.getFullTickCount() % 4 == 0 && ActivationRange.checkEntityImmunities(entity, currentTick) < 0) {
            return false;
        }
        return active;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldTick(Entity entity) {
        if (ActivationRangeConfig.ENABLED.get() == false) return true;
        if (entity.isExcluded()) return true;
        if (entity.f_19817_) return true;
        if (entity.m_20092_()) return true;
        if (entity.f_19797_ < 200) {
            if (entity.getActivationType() == ActivationType.MISC) return true;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.f_21357_ instanceof Player) return true;
        }
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity living = (LivingEntity)entity;
        if (living.f_20916_ <= 0) return false;
        return true;
    }

    private static int checkInactiveWakeup(Entity entity, int currentTick) {
        LevelInfo info;
        int remaining;
        ActivationType.Wakeup wakeup = entity.getActivationType().wakeup;
        if (wakeup != null && (long)(currentTick - entity.getActivatedTick()) >= (long)wakeup.interval.getAsInt() * 20L && (remaining = (info = (LevelInfo)entity.f_19853_).getRemaining(wakeup)) > 0) {
            info.setRemaining(wakeup, remaining - 1);
            return 100;
        }
        return -1;
    }
}

