/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.fluid;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.FluidSnapshot;
import earth.terrarium.botarium.api.fluid.SimpleFluidSnapshot;
import earth.terrarium.botarium.api.fluid.UpdatingFluidContainer;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.IntToLongFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluids;

public class SimpleUpdatingFluidContainer
implements UpdatingFluidContainer<BlockEntity> {
    public NonNullList<FluidHolder> storedFluid;
    public final IntToLongFunction maxAmount;
    public final BiPredicate<Integer, FluidHolder> fluidFilter;
    public final Updatable updatable;

    public SimpleUpdatingFluidContainer(Updatable updatable, IntToLongFunction maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this.updatable = updatable;
        this.maxAmount = maxAmount;
        this.fluidFilter = fluidFilter;
        this.storedFluid = NonNullList.m_122780_((int)tanks, (Object)FluidHooks.emptyFluid());
    }

    public SimpleUpdatingFluidContainer(Updatable updatable, long maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this(updatable, integer -> maxAmount, tanks, fluidFilter);
    }

    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            if (((FluidHolder)this.storedFluid.get(i)).isEmpty()) {
                FluidHolder insertedFluid = fluid.copyHolder();
                insertedFluid.setAmount(Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)this.maxAmount.applyAsLong(i)));
                if (simulate) {
                    return insertedFluid.getFluidAmount();
                }
                this.storedFluid.set(i, (Object)insertedFluid);
                return ((FluidHolder)this.storedFluid.get(i)).getFluidAmount();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long insertedAmount = Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)(this.maxAmount.applyAsLong(i) - ((FluidHolder)this.storedFluid.get(i)).getFluidAmount()));
            if (simulate) {
                return insertedAmount;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() + insertedAmount);
            return insertedAmount;
        }
        return 0L;
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            FluidHolder toExtract = fluid.copyHolder();
            if (this.storedFluid.isEmpty()) {
                return FluidHooks.emptyFluid();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long extractedAmount = Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)((FluidHolder)this.storedFluid.get(i)).getFluidAmount());
            toExtract.setAmount(extractedAmount);
            if (simulate) {
                return toExtract;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() - extractedAmount);
            if (((FluidHolder)this.storedFluid.get(i)).getFluidAmount() == 0L) {
                this.storedFluid.set(i, (Object)FluidHooks.emptyFluid());
            }
            return toExtract;
        }
        return FluidHooks.emptyFluid();
    }

    public long internalInsert(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            if (((FluidHolder)this.storedFluid.get(i)).isEmpty()) {
                FluidHolder insertedFluid = fluid.copyHolder();
                insertedFluid.setAmount(Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)this.maxAmount.applyAsLong(i)));
                if (simulate) {
                    return insertedFluid.getFluidAmount();
                }
                this.storedFluid.set(i, (Object)insertedFluid);
                return ((FluidHolder)this.storedFluid.get(i)).getFluidAmount();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long insertedAmount = Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)(this.maxAmount.applyAsLong(i) - ((FluidHolder)this.storedFluid.get(i)).getFluidAmount()));
            if (simulate) {
                return insertedAmount;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() + insertedAmount);
            return insertedAmount;
        }
        return 0L;
    }

    public FluidHolder internalExtract(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            FluidHolder toExtract = fluid.copyHolder();
            if (this.storedFluid.isEmpty()) {
                return FluidHooks.emptyFluid();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long extractedAmount = Mth.m_14053_((long)fluid.getFluidAmount(), (long)0L, (long)((FluidHolder)this.storedFluid.get(i)).getFluidAmount());
            toExtract.setAmount(extractedAmount);
            if (simulate) {
                return toExtract;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() - extractedAmount);
            if (((FluidHolder)this.storedFluid.get(i)).getFluidAmount() == 0L) {
                this.storedFluid.set(i, (Object)FluidHooks.emptyFluid());
            }
            return toExtract;
        }
        return FluidHooks.emptyFluid();
    }

    @Override
    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        if (Objects.equals(fluidHolder.getCompound(), toInsert.getCompound()) && fluidHolder.getFluid().m_6212_(toInsert.getFluid())) {
            long extracted = Mth.m_14053_((long)toInsert.getFluidAmount(), (long)0L, (long)fluidHolder.getFluidAmount());
            snapshot.run();
            fluidHolder.setAmount(fluidHolder.getFluidAmount() - extracted);
            if (fluidHolder.getFluidAmount() == 0L) {
                fluidHolder.setFluid(Fluids.f_76191_);
            }
            return extracted;
        }
        return 0L;
    }

    @Override
    public void setFluid(int slot, FluidHolder fluid) {
        this.storedFluid.set(slot, (Object)fluid);
    }

    @Override
    public List<FluidHolder> getFluids() {
        return this.storedFluid;
    }

    @Override
    public int getSize() {
        return this.getFluids().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getFluids().isEmpty() || this.getFluids().get(0) == null || this.getFluids().get(0).isEmpty();
    }

    public void clear() {
        this.storedFluid.clear();
        this.update();
    }

    @Override
    public SimpleUpdatingFluidContainer copy() {
        return new SimpleUpdatingFluidContainer(this.updatable, this.maxAmount, this.getSize(), this.fluidFilter);
    }

    @Override
    public long getTankCapacity(int slot) {
        return this.maxAmount.applyAsLong(slot);
    }

    @Override
    public void fromContainer(FluidContainer container) {
        this.storedFluid = NonNullList.m_122780_((int)container.getSize(), (Object)FluidHooks.emptyFluid());
        for (int i = 0; i < container.getSize(); ++i) {
            this.storedFluid.set(i, (Object)container.getFluids().get(i).copyHolder());
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        ListTag fluids = tag.m_128437_("StoredFluids", 10);
        for (int i = 0; i < fluids.size(); ++i) {
            CompoundTag fluid = fluids.m_128728_(i);
            this.storedFluid.set(i, (Object)FluidHooks.fluidFromCompound(fluid));
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        if (!this.storedFluid.isEmpty()) {
            ListTag tags = new ListTag();
            for (FluidHolder fluidHolder : this.storedFluid) {
                tags.add((Object)fluidHolder.serialize());
            }
            tag.m_128365_("StoredFluids", (Tag)tags);
        }
        return tag;
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    public void update() {
        this.updatable.update();
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return new SimpleFluidSnapshot(this);
    }

    @Override
    public void update(BlockEntity block) {
        this.updatable.update();
    }
}

