/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.mortar;

import elucent.rootsclassic.blockentity.BEBase;
import elucent.rootsclassic.recipe.ComponentRecipe;
import elucent.rootsclassic.registry.RootsRecipes;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MortarBlockEntity
extends BEBase {
    public final ItemStackHandler inventory = new ItemStackHandler(8){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            MortarBlockEntity.this.calculateRotations();
        }
    };
    private LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);

    public MortarBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public MortarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)RootsRegistry.MORTAR_TILE.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("InventoryHandler"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InventoryHandler", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void breakBlock(Level levelAccessor, BlockPos pos, BlockState state, Player player) {
        this.dropAllItems(levelAccessor, pos);
        this.m_7651_();
    }

    @Override
    public InteractionResult activate(Level levelAccessor, BlockPos pos, BlockState state, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        if (hand == InteractionHand.MAIN_HAND) {
            if (heldItem.m_41619_()) {
                return this.tryDropSingleItem(levelAccessor, pos, state);
            }
            if (heldItem.m_41720_() == RootsRegistry.PESTLE.get()) {
                return this.tryActivateRecipe(player, state);
            }
            return this.tryInsertItem(levelAccessor, pos, state, heldItem);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryInsertItem(Level levelAccessor, BlockPos pos, BlockState state, ItemStack heldItem) {
        if (!heldItem.m_41619_() && !InventoryUtil.isFull((IItemHandler)this.inventory)) {
            ItemStack heldCopy = heldItem.m_41777_();
            heldCopy.m_41764_(1);
            if (heldItem.m_41720_() == Items.f_42525_ || heldItem.m_41720_() == Items.f_42451_ || heldItem.m_41720_() == Items.f_42403_) {
                int maxCapacity = ComponentRecipe.getModifierCapacity(InventoryUtil.createIInventory((IItemHandler)this.inventory));
                int modifierCount = ComponentRecipe.getModifierCount(InventoryUtil.createIInventory((IItemHandler)this.inventory));
                if (modifierCount < maxCapacity) {
                    ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)heldCopy, (boolean)false);
                    if (restStack.m_41619_()) {
                        heldItem.m_41774_(1);
                        this.m_6596_();
                        levelAccessor.m_7260_(this.m_58899_(), state, levelAccessor.m_8055_(pos), 3);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
            } else {
                ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)heldCopy, (boolean)false);
                if (restStack.m_41619_()) {
                    heldItem.m_41774_(1);
                    this.m_6596_();
                    levelAccessor.m_7260_(this.m_58899_(), state, levelAccessor.m_8055_(pos), 3);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryDropSingleItem(Level levelAccessor, BlockPos pos, BlockState state) {
        if (!InventoryUtil.isEmpty((IItemHandler)this.inventory)) {
            ItemStack lastStack = InventoryUtil.getLastStack((IItemHandler)this.inventory);
            if (!lastStack.m_41619_()) {
                this.dropItem(lastStack, 0.5f);
                lastStack.m_41774_(1);
            }
            this.m_6596_();
            levelAccessor.m_7260_(this.m_58899_(), state, levelAccessor.m_8055_(pos), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryActivateRecipe(Player player, BlockState state) {
        ComponentRecipe recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)RootsRecipes.COMPONENT_RECIPE_TYPE.get(), (Container)InventoryUtil.createIInventory((IItemHandler)this.inventory), this.f_58857_).orElse(null);
        if (recipe == null) {
            player.m_5661_((Component)Component.m_237115_((String)"rootsclassic.mortar.invalid"), true);
            return InteractionResult.PASS;
        }
        if (recipe.needsMixin() && ComponentRecipe.getModifierCapacity(InventoryUtil.createIInventory((IItemHandler)this.inventory)) < 0) {
            player.m_5661_((Component)Component.m_237115_((String)"rootsclassic.mortar.mixin"), true);
            return InteractionResult.PASS;
        }
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, recipe.m_5874_(InventoryUtil.createIInventory((IItemHandler)this.inventory))));
        }
        InventoryUtil.clearInventory((IItemHandler)this.inventory);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), state, this.f_58857_.m_8055_(this.f_58858_), 3);
        return InteractionResult.SUCCESS;
    }

    public void dropItem(ItemStack stack, float offsetY) {
        ItemStack copyStack = stack.m_41777_();
        if (copyStack.m_41619_() || this.f_58857_.f_46443_) {
            return;
        }
        BlockPos pos = this.m_58899_();
        ItemEntity itementity = new ItemEntity(this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_() + (double)offsetY, (double)this.f_58858_.m_123343_(), copyStack);
        itementity.m_32060_();
        this.f_58857_.m_7967_((Entity)itementity);
    }

    private void dropAllItems(Level levelAccessor, BlockPos pos) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            this.dropItem(stack, 0.0f);
        }
    }

    private void calculateRotations() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
    }
}

