/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.block.counter;

import earth.terrarium.handcrafted.common.block.counter.StorageBlockEntity;
import earth.terrarium.handcrafted.common.item.HammerItem;
import earth.terrarium.handcrafted.common.item.Hammerable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class CupboardBlock
extends BaseEntityBlock
implements Hammerable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public CupboardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    @Override
    public void onHammer(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        StorageBlockEntity storage;
        Block block = state.m_60734_();
        ResourceLocation id = Registry.f_122824_.m_7981_((Object)block);
        Block replacement = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(id.m_135827_(), id.m_135815_().replaceAll("\\d+", String.valueOf(Integer.parseInt(id.m_135815_().replaceAll("\\D+", "")) + 1))));
        CompoundTag tag = null;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            storage = (StorageBlockEntity)blockEntity;
            tag = storage.m_187482_();
        }
        if (replacement == Blocks.f_50016_) {
            level.m_7731_(pos, (BlockState)((Block)Registry.f_122824_.m_7745_(new ResourceLocation(id.m_135827_(), id.m_135815_().replaceAll("\\d+", "1")))).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
        } else {
            level.m_7731_(pos, (BlockState)replacement.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
        }
        if (tag != null && (blockEntity = level.m_7702_(pos)) instanceof StorageBlockEntity) {
            storage = (StorageBlockEntity)blockEntity;
            storage.m_142466_(tag);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ResourceLocation id = Registry.f_122824_.m_7981_((Object)state.m_60734_());
        return ((Item)Registry.f_122827_.m_7745_(new ResourceLocation(id.m_135827_(), id.m_135815_().substring(0, id.m_135815_().length() - 2)))).m_7968_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21205_().m_41720_() instanceof HammerItem) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity storage = (StorageBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)storage);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !(newState.m_60734_() instanceof CupboardBlock)) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StorageBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

