/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.message;

import com.mrcrayfish.configured.network.MessageHelper;
import com.mrcrayfish.configured.network.play.ClientPlayHandler;
import com.mrcrayfish.configured.network.play.ServerPlayHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record MessageSyncSimpleConfig(ResourceLocation id, byte[] data) {
    public static void encode(MessageSyncSimpleConfig message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.id);
        buffer.m_130087_(message.data);
    }

    public static MessageSyncSimpleConfig decode(FriendlyByteBuf buffer) {
        return new MessageSyncSimpleConfig(buffer.m_130281_(), buffer.m_130052_());
    }

    public static void handle(MessageSyncSimpleConfig message, Supplier<NetworkEvent.Context> supplier) {
        if (supplier.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer player = supplier.get().getSender();
            if (player != null) {
                MessageHelper.enqueueTask(supplier, () -> ServerPlayHandler.handleSyncSimpleConfigMessage((NetworkEvent.Context)supplier.get(), player, message));
            }
        } else {
            MessageHelper.enqueueTask(supplier, () -> ClientPlayHandler.handleSyncSimpleConfigMessage((NetworkEvent.Context)supplier.get(), message));
        }
    }
}

