/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class ShapelessRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object output;
    public final int count;
    public final Object[] input;

    public ShapelessRecipeSerializer(ResourceLocation key, Object output, int count, Object ... input) {
        this(key, "", output, count, input);
    }

    public ShapelessRecipeSerializer(ResourceLocation key, String group, Object output, int count, Object ... input) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.output = output;
        this.count = count;
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public JsonElement get() {
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        NonNullList ingredients = NonNullList.m_122779_();
        for (Object in : this.input) {
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(in);
            if (ing == EmptyIngredient.INSTANCE) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            ingredients.add((Object)ing);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        JsonArray ingJson = new JsonArray();
        for (Ingredient ingredient : ingredients) {
            ingJson.add(ingredient.m_43942_());
        }
        json.add("ingredients", (JsonElement)ingJson);
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        return json;
    }
}

