/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.nuclearcraft;

import com.google.gson.JsonElement;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IFluidStackIngredientCreator;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.compat.nuclearcraft.recipes.CentrifugeRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.recipes.CrystallizerRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.recipes.IngotFormerRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.recipes.LeacherRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.recipes.ManufactoryRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.recipes.MelterRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.recipes.PressurizerRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class NuclearCraftHelper {
    public static final NuclearCraftHelper INSTANCE = new NuclearCraftHelper();

    private NuclearCraftHelper() {
    }

    public FluidStackIngredient getFluidStackIngredient(Object obj, int amount) {
        return (FluidStackIngredient)this.getFluidStackIngredientResolved(obj, amount).getLeft();
    }

    public Pair<FluidStackIngredient, Set<Fluid>> getFluidStackIngredientResolved(Object obj, int amount) {
        FluidStackIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        IFluidStackIngredientCreator creator = IngredientCreatorAccess.fluid();
        if (obj instanceof Supplier) {
            Pair<FluidStackIngredient, Set<Fluid>> pair = this.getFluidStackIngredientResolved(((Supplier)obj).get(), amount);
            ing = (FluidStackIngredient)pair.getLeft();
            fluids.addAll((Collection)pair.getRight());
        } else if (obj instanceof FluidStackIngredient) {
            ing = (FluidStackIngredient)obj;
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = (FluidStackIngredient)creator.from(helper.getFluidTagKey(location), amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = (FluidStackIngredient)creator.from(helper.getFluidTagKey(location), amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = (FluidStackIngredient)creator.from(key, amount);
            fluids.addAll(helper.getFluidTagValues(key.f_203868_()));
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            if (!stack.isEmpty()) {
                ing = (FluidStackIngredient)creator.from((Object)stack);
                fluids.add(stack.getFluid());
            }
        } else if (obj instanceof FluidStack[]) {
            FluidStack[] stacks = (FluidStack[])obj;
            List<FluidStack> nonEmpty = Arrays.stream(stacks).filter(s -> !s.isEmpty()).toList();
            if (!nonEmpty.isEmpty()) {
                ing = (FluidStackIngredient)creator.from(nonEmpty.stream().map(arg_0 -> ((IFluidStackIngredientCreator)creator).from(arg_0)));
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
            }
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            if (fluid != Fluids.f_76191_) {
                ing = creator.from(fluid, amount);
                fluids.add(fluid);
            }
        } else if (obj instanceof Fluid[]) {
            Fluid[] fluidz = (Fluid[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = (FluidStackIngredient)creator.from(nonEmpty.stream().map(f -> creator.from(f, amount)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)obj;
            if (fluid.asFluid() != Fluids.f_76191_) {
                ing = creator.from(fluid.asFluid(), amount);
                fluids.add(fluid.asFluid());
            }
        } else if (obj instanceof IFluidLike[]) {
            IFluidLike[] fluidz = (IFluidLike[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).map(IFluidLike::asFluid).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = (FluidStackIngredient)creator.from(nonEmpty.stream().map(f -> creator.from(f, amount)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof JsonElement) {
            ing = (FluidStackIngredient)creator.deserialize((JsonElement)obj);
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        }
        fluids.remove(Fluids.f_76191_);
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public boolean registerLeacherRecipe(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputAmount, double radiation, double time, double power) {
        return ApiImpl.INSTANCE.registerRecipe(key, new LeacherRecipeSerializer(key, itemInput, itemInputCount, fluidInput, fluidInputAmount, output, outputAmount, radiation, time, power));
    }

    public boolean registerManufactoryRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, double radiation, double time, double power) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ManufactoryRecipeSerializer(key, input, inputCount, output, outputCount, radiation, time, power));
    }

    public boolean registerCentrifugeRecipe(ResourceLocation key, Object input, int inputAmount, Object[] output, double radiation, double time, double power) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CentrifugeRecipeSerializer(key, input, inputAmount, output, radiation, time, power));
    }

    public boolean registerCrystallizerRecipe(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, double radiation, double time, double power) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CrystallizerRecipeSerializer(key, input, inputAmount, output, outputCount, radiation, time, power));
    }

    public boolean registerIngotFormerRecipe(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, double radiation, double time, double power) {
        return ApiImpl.INSTANCE.registerRecipe(key, new IngotFormerRecipeSerializer(key, input, inputAmount, output, outputCount, radiation, time, power));
    }

    public boolean registerMelterRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputAmount, double radiation, double time, double power) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MelterRecipeSerializer(key, input, inputCount, output, outputAmount, radiation, time, power));
    }

    public boolean registerPressurizerRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, double radiation, double time, double power) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PressurizerRecipeSerializer(key, input, inputCount, output, outputCount, radiation, time, power));
    }
}

