/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.mekanism.MekanismHelper;
import thelm.jaopca.utils.MiscHelper;

public class InjectingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object gasInput;
    public final int gasInputAmount;
    public final Object output;
    public final int outputCount;

    public InjectingRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputAmount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.gasInput = gasInput;
        this.gasInputAmount = gasInputAmount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public JsonElement get() {
        ItemStackIngredient ing = MekanismHelper.INSTANCE.getItemStackIngredient(this.itemInput, this.itemInputCount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.itemInput));
        }
        ChemicalStackIngredient.GasStackIngredient gasIng = MekanismHelper.INSTANCE.getGasStackIngredient(this.gasInput, this.gasInputAmount);
        if (gasIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.gasInput));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "mekanism:injecting");
        json.add("itemInput", ing.serialize());
        json.add("chemicalInput", gasIng.serialize());
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        return json;
    }
}

