/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.ftbic.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class MaceratingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object[] output;
    public final double time;

    public MaceratingRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object[] output, double time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ArrayList<StackWithChance> outputs = new ArrayList<StackWithChance>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Double chance = 1.0;
            if (i < this.output.length && this.output[i] instanceof Double) {
                chance = (Double)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).m_41619_()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(new StackWithChance(stack, chance.doubleValue()));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "ftbic:macerating");
        JsonArray itemInputJson = new JsonArray();
        itemInputJson.add((JsonElement)new IngredientWithCount(ing, this.inputCount).toJson());
        json.add("inputItems", (JsonElement)itemInputJson);
        JsonArray itemOutputJson = new JsonArray();
        for (StackWithChance stack : outputs) {
            itemOutputJson.add((JsonElement)stack.toJson());
        }
        json.add("outputItems", (JsonElement)itemOutputJson);
        json.addProperty("processingTime", (Number)this.time);
        return json;
    }
}

