/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create;

import com.google.gson.JsonElement;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.compat.create.recipes.CrushingRecipeSerializer;
import thelm.jaopca.compat.create.recipes.MillingRecipeSerializer;
import thelm.jaopca.compat.create.recipes.PressingRecipeSerializer;
import thelm.jaopca.compat.create.recipes.SplashingRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class CreateHelper {
    public static final CreateHelper INSTANCE = new CreateHelper();

    private CreateHelper() {
    }

    public FluidIngredient getFluidIngredient(Object obj, int amount) {
        return (FluidIngredient)this.getFluidIngredientResolved(obj, amount).getLeft();
    }

    public Pair<FluidIngredient, Set<Fluid>> getFluidIngredientResolved(Object obj, int amount) {
        FluidIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        if (obj instanceof Supplier) {
            Pair<FluidIngredient, Set<Fluid>> pair = this.getFluidIngredientResolved(((Supplier)obj).get(), amount);
            ing = (FluidIngredient)pair.getLeft();
            fluids.addAll((Collection)pair.getRight());
        } else if (obj instanceof FluidIngredient) {
            ing = (FluidIngredient)obj;
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = FluidIngredient.fromTag(helper.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = FluidIngredient.fromTag(helper.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = FluidIngredient.fromTag((TagKey)key, (int)amount);
            fluids.addAll(helper.getFluidTagValues(key.f_203868_()));
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            if (!stack.isEmpty()) {
                ing = FluidIngredient.fromFluidStack((FluidStack)stack);
                fluids.add(stack.getFluid());
            }
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            if (fluid != Fluids.f_76191_) {
                ing = FluidIngredient.fromFluid((Fluid)fluid, (int)amount);
                fluids.add(fluid);
            }
        } else if (obj instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)obj;
            if (fluid.asFluid() != Fluids.f_76191_) {
                ing = FluidIngredient.fromFluid((Fluid)fluid.asFluid(), (int)amount);
                fluids.add(fluid.asFluid());
            }
        } else if (obj instanceof JsonElement) {
            ing = FluidIngredient.deserialize((JsonElement)((JsonElement)obj));
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        }
        fluids.remove(Fluids.f_76191_);
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public boolean registerCrushingRecipe(ResourceLocation key, Object input, int time, Object ... output) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CrushingRecipeSerializer(key, input, time, output));
    }

    public boolean registerMillingRecipe(ResourceLocation key, Object input, int time, Object ... output) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MillingRecipeSerializer(key, input, time, output));
    }

    public boolean registerPressingRecipe(ResourceLocation key, Object input, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PressingRecipeSerializer(key, input, output, outputCount));
    }

    public boolean registerSplashingRecipe(ResourceLocation key, Object input, Object ... output) {
        return ApiImpl.INSTANCE.registerRecipe(key, new SplashingRecipeSerializer(key, input, output));
    }
}

