/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.assemblylinemachines.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class GrinderRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final int grinds;
    public final int tier;
    public final boolean requiresMachine;
    public final float doubleChance;

    public GrinderRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, int grinds, int tier, boolean requiresMachine, float doubleChance) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.grinds = grinds;
        this.tier = tier;
        this.requiresMachine = requiresMachine;
        this.doubleChance = doubleChance;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        String blade = this.tier <= 0 ? "TITANIUM" : (this.tier == 1 ? "PUREGOLD" : "STEEL");
        JsonObject json = new JsonObject();
        json.addProperty("type", "assemblylinemachines:grinder");
        json.add("input", ing.m_43942_());
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.addProperty("grinds", (Number)this.grinds);
        json.addProperty("bladetype", blade);
        json.addProperty("machine_required", Boolean.valueOf(this.requiresMachine));
        json.addProperty("chanceToDouble", (Number)Float.valueOf(this.doubleChance));
        return json;
    }
}

