/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.functions;

import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public class MemoizingDoubleSupplier
implements DoubleSupplier {
    private DoubleSupplier delegate;
    private double value;

    private MemoizingDoubleSupplier(DoubleSupplier delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public static MemoizingDoubleSupplier of(DoubleSupplier delegate) {
        return new MemoizingDoubleSupplier(delegate);
    }

    public static <T> MemoizingDoubleSupplier of(ToDoubleFunction<T> function, Supplier<T> value) {
        return new MemoizingDoubleSupplier(() -> function.applyAsDouble(value.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getAsDouble() {
        if (this.delegate != null) {
            MemoizingDoubleSupplier memoizingDoubleSupplier = this;
            synchronized (memoizingDoubleSupplier) {
                if (this.delegate != null) {
                    this.value = this.delegate.getAsDouble();
                    this.delegate = null;
                }
            }
        }
        return this.value;
    }
}

