/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.ColorUtils;

public class GuiRowLabel
extends GuiLabel {
    public final int index;
    public final Consumer<Integer> consumer;
    public final boolean selected;

    public GuiRowLabel(String name, int index, boolean selected, Consumer<Integer> consumer) {
        super(name);
        this.index = index;
        this.consumer = consumer;
        this.selected = selected;
        this.setExpandableX();
    }

    public GuiRowLabel set(CompiledText text) {
        this.text = text;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        if (this.selected) {
            this.text.setDefaultColor(rect.inside(mouseX, mouseY) ? ColorUtils.rgba(230, 230, 0, 255) : ColorUtils.rgba(200, 200, 0, 255));
        } else if (rect.inside(mouseX, mouseY)) {
            this.text.setDefaultColor(-256);
        } else {
            this.text.setDefaultColor(-1);
        }
        super.renderContent(pose, control, rect, mouseX, mouseY);
        this.text.setDefaultColor(-1);
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        this.consumer.accept(button);
        GuiRowLabel.playSound(SoundEvents.f_12490_);
        return true;
    }
}

