/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore;

import java.util.ArrayList;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlot;
import team.creative.creativecore.common.gui.controls.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobal;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;

public class CreativeCoreGuiRegistry {
    public static final GuiSyncGlobal<GuiLayer, CompoundTag> HAND = GuiSyncHolder.GLOBAL.register("hand", (c, t) -> c.itemManager().setHand(ItemStack.m_41712_((CompoundTag)t)));
    public static final GuiSyncGlobal<GuiSlot, ByteTag> DROP = GuiSyncHolder.GLOBAL.register("drop", (c, t) -> {
        boolean ctrl = t.m_7063_() == 1;
        Slot slot = c.slot;
        Player player = c.getPlayer();
        if (slot.m_6657_() && slot.m_8010_(player)) {
            ItemStack drop = slot.m_7993_().m_41777_();
            if (ctrl) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                drop.m_41764_(1);
            }
            ItemStack newStack = slot.m_7993_();
            newStack.m_41774_(1);
            player.m_36176_(drop, true);
            slot.m_142406_(player, drop);
            c.changed();
        }
    });
    public static final GuiSyncGlobal<GuiLayer, EndTag> DROP_HAND = GuiSyncHolder.GLOBAL.register("drop_hand", (c, t) -> {
        ItemStack hand = c.itemManager().getHand();
        Player player = c.getPlayer();
        if (!hand.m_41619_()) {
            player.m_36176_(hand, true);
            c.itemManager().setHand(ItemStack.f_41583_);
        }
    });
    public static final GuiSyncGlobal<GuiSlot, IntTag> INSERT = GuiSyncHolder.GLOBAL.register("insert", (c, t) -> {
        Slot slot = c.slot;
        GuiLayer layer = c.getLayer();
        ItemStack stack = slot.m_7993_();
        int amount = Math.min(t.m_7047_(), stack.m_41613_());
        ItemStack insert = slot.m_6201_(amount);
        for (IGuiInventory inv : layer.inventoriesToInsert()) {
            if (inv == c.inventory()) continue;
            inv.insert(insert, false);
            if (!insert.m_41619_()) {
                inv.insert(insert, true);
            }
            if (!insert.m_41619_()) continue;
            break;
        }
        stack.m_41769_(insert.m_41613_());
        c.changed();
    });
    public static final GuiSyncGlobal<GuiSlot, IntTag> EXTRACT = GuiSyncHolder.GLOBAL.register("exract", (c, t) -> {
        Slot slot = c.slot;
        GuiLayer layer = c.getLayer();
        ItemStack stack = slot.m_7993_();
        if (stack.m_41619_() || !slot.m_5857_(stack)) {
            return;
        }
        int amount = Math.min(t.m_7047_(), slot.m_5866_(stack) - stack.m_41613_());
        ItemStack extract = stack.m_41777_();
        extract.m_41764_(amount);
        for (IGuiInventory inv : layer.inventoriesToExract()) {
            if (inv == c.inventory()) continue;
            inv.extract(extract);
            if (!extract.m_41619_()) continue;
            break;
        }
        stack.m_41769_(amount - extract.m_41613_());
        c.changed();
    });
    public static final GuiSyncGlobal<GuiSlot, EndTag> DUPLICATE = GuiSyncHolder.GLOBAL.register("duplicate", (c, t) -> {
        Slot slot = c.slot;
        Player player = c.getPlayer();
        if (player.m_7500_()) {
            ItemStack stack = slot.m_7993_().m_41777_();
            stack.m_41764_(stack.m_41741_());
            c.itemManager().setHand(stack);
        }
    });
    public static final GuiSyncGlobal<GuiSlot, ByteTag> SWAP = GuiSyncHolder.GLOBAL.register("swap", (c, t) -> {
        boolean rightClick = t.m_7063_() == 1;
        Slot slot = c.slot;
        Player player = c.getPlayer();
        ItemStack hand = c.itemManager().getHand();
        if (slot.m_8010_(player) && (hand.m_41619_() || slot.m_5857_(hand))) {
            ItemStack pickup = hand.m_41619_() && rightClick ? slot.m_6201_(Math.max(1, slot.m_7993_().m_41613_() / 2)) : slot.m_6201_(slot.m_7993_().m_41613_());
            slot.m_142406_(player, pickup);
            if (!hand.m_41619_()) {
                slot.m_5852_(hand);
            }
            c.itemManager().setHand(pickup);
            c.changed();
        }
    });
    public static final GuiSyncGlobal<GuiLayer, CompoundTag> SPREAD = GuiSyncHolder.GLOBAL.register("spread", (c, t) -> {
        ItemStack hand = c.itemManager().getHand().m_41777_();
        Player player = c.getPlayer();
        if (hand.m_41619_()) {
            return;
        }
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        ListTag names = t.m_128437_("names", 8);
        for (int i = 0; i < names.size(); ++i) {
            inventories.add((IGuiInventory)c.get(names.m_128778_(i)));
        }
        ArrayList<GuiSlot> slots = new ArrayList<GuiSlot>();
        int[] ids = t.m_128465_("ids");
        for (int i = 0; i < ids.length; i += 2) {
            slots.add(((IGuiInventory)inventories.get(ids[i])).getSlot(ids[i + 1]));
        }
        int countPerSlot = Math.max(1, Mth.m_14143_((float)((float)hand.m_41613_() / (float)slots.size())));
        boolean rightClick = t.m_128471_("rightClick");
        if (rightClick) {
            countPerSlot = 1;
        }
        for (GuiSlot slot : slots) {
            if (!slot.slot.m_5857_(hand)) continue;
            ItemStack stack = slot.getStack();
            int transfer = Math.min(countPerSlot, slot.slot.m_5866_(hand) - slot.getStack().m_41613_());
            ItemStack toTransfer = hand.m_41777_();
            toTransfer.m_41764_(transfer);
            if (transfer <= 0) continue;
            if (!toTransfer.m_150926_(slot.slot, rightClick ? ClickAction.SECONDARY : ClickAction.PRIMARY, player) && !stack.m_150932_(toTransfer, slot.slot, rightClick ? ClickAction.SECONDARY : ClickAction.PRIMARY, player, c.itemManager().handAccess)) {
                if (!slot.slot.m_6657_()) {
                    slot.slot.m_5852_(toTransfer);
                } else {
                    if (!ItemStack.m_150942_((ItemStack)toTransfer, (ItemStack)stack)) continue;
                    stack.m_41769_(transfer);
                }
                hand.m_41774_(transfer);
            } else {
                hand = c.itemManager().getHand();
            }
            slot.changed();
        }
        c.itemManager().setHand(hand);
    });

    public static void init() {
    }
}

