/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCoreConfig;
import team.creative.creativecore.CreativeForgeLoader;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.config.event.ConfigEventHandler;
import team.creative.creativecore.common.config.gui.ClientSyncGuiLayer;
import team.creative.creativecore.common.config.gui.ConfigGuiLayer;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigurationChangePacket;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.config.sync.ConfigurationPacket;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.packet.ControlSyncPacket;
import team.creative.creativecore.common.gui.packet.ImmediateItemStackPacket;
import team.creative.creativecore.common.gui.packet.LayerClosePacket;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.gui.packet.SyncPacket;
import team.creative.creativecore.common.loader.ForgeLoaderUtils;
import team.creative.creativecore.common.loader.ILoaderUtils;
import team.creative.creativecore.common.network.CreativeNetwork;

@Mod(value="creativecore")
public class CreativeCore {
    private static final ICreativeLoader LOADER = new CreativeForgeLoader();
    private static final ILoaderUtils UTILS = new ForgeLoaderUtils();
    public static final String MODID = "creativecore";
    public static final Logger LOGGER = LogManager.getLogger((String)"creativecore");
    public static final CreativeCoreConfig CONFIG = new CreativeCoreConfig();
    public static final CreativeNetwork NETWORK = new CreativeNetwork(1, LOGGER, new ResourceLocation("creativecore", "main"));
    public static ConfigEventHandler CONFIG_HANDLER;
    public static MenuType<ContainerIntegration> GUI_CONTAINER;
    public static final GuiCreator.GuiCreatorBasic CONFIG_OPEN;
    public static final GuiCreator.GuiCreatorBasic CONFIG_CLIENT_SYNC_OPEN;

    public CreativeCore() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerMenus);
        MinecraftForge.EVENT_BUS.addListener(this::server);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreativeCoreClient.load(FMLJavaModLoadingContext.get().getModEventBus()));
        GUI_CONTAINER = new MenuType<ContainerIntegration>(null){

            public ContainerIntegration create(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_);
            }

            public ContainerIntegration create(int windowId, Inventory playerInv) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_);
            }
        };
    }

    public void registerMenus(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.MENU_TYPES, x -> x.register("container", GUI_CONTAINER));
    }

    private void server(ServerStartingEvent event) {
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"cmdconfig").executes(x -> {
            CONFIG_OPEN.open(new CompoundTag(), (Player)((CommandSourceStack)x.getSource()).m_81375_());
            return 0;
        }));
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ConfigurationChangePacket.class, ConfigurationChangePacket::new);
        NETWORK.registerType(ConfigurationClientPacket.class, ConfigurationClientPacket::new);
        NETWORK.registerType(ConfigurationPacket.class, ConfigurationPacket::new);
        NETWORK.registerType(LayerClosePacket.class, LayerClosePacket::new);
        NETWORK.registerType(OpenGuiPacket.class, OpenGuiPacket::new);
        NETWORK.registerType(ControlSyncPacket.class, ControlSyncPacket::new);
        NETWORK.registerType(SyncPacket.class, SyncPacket::new);
        NETWORK.registerType(ImmediateItemStackPacket.class, ImmediateItemStackPacket::new);
        CONFIG_HANDLER = new ConfigEventHandler(FMLPaths.CONFIGDIR.get().toFile(), LOGGER);
        LOADER.loadCommon();
    }

    public static ICreativeLoader loader() {
        return LOADER;
    }

    public static ILoaderUtils utils() {
        return UTILS;
    }

    static {
        CONFIG_OPEN = GuiCreator.register("config", new GuiCreator.GuiCreatorBasic((player, nbt) -> new ConfigGuiLayer(CreativeConfigRegistry.ROOT, Side.SERVER)));
        CONFIG_CLIENT_SYNC_OPEN = GuiCreator.register("clientconfig", new GuiCreator.GuiCreatorBasic((player, nbt) -> new ClientSyncGuiLayer(CreativeConfigRegistry.ROOT)));
    }
}

