/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.compat.CompatibleManager;
import ad_astra_giselle_addon.common.compat.create.BacktankOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorageItem;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.OxygenCanItem;
import earth.terrarium.ad_astra.common.registry.ModFluids;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class OxygenStorageUtils {
    public static OptionalDouble getExtractableStoredRatio(LivingEntity living) {
        List<ItemStackReference> items = LivingHelper.getInventoryItems(living);
        long stored = 0L;
        long capacity = 0L;
        int temperature = (int)ModUtils.getWorldTemperature((Level)living.m_9236_());
        for (ItemStackReference item : items) {
            IOxygenStorage oxygenStorage = OxygenStorageUtils.get(item);
            if (oxygenStorage == null || !oxygenStorage.getTemperatureThreshold().contains((Object)temperature)) continue;
            stored += oxygenStorage.getOxygenAmount();
            capacity += oxygenStorage.getOxygenCapacity();
        }
        if (capacity == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)stored / (double)capacity);
    }

    @Nullable
    public static IOxygenStorage firstExtractable(LivingEntity living, long extracting) {
        return OxygenStorageUtils.streamExtractable(living, extracting).findFirst().orElse(null);
    }

    @Nullable
    public static Stream<IOxygenStorage> streamExtractable(LivingEntity living, long extracting) {
        int temperature = (int)ModUtils.getWorldTemperature((Level)living.m_9236_());
        return LivingHelper.getInventoryItems(living).stream().map(OxygenStorageUtils::get).filter(oxygenStorage -> {
            long extract;
            return oxygenStorage != null && oxygenStorage.getTemperatureThreshold().contains((Object)temperature) && (extract = oxygenStorage.extractOxygen(living, extracting, true)) >= extracting;
        });
    }

    @Nullable
    public static IOxygenStorage get(ItemStackHolder item) {
        IOxygenStorage storage;
        Item item2 = item.getStack().m_41720_();
        if (item2 instanceof IOxygenStorageItem) {
            IOxygenStorageItem oxygenStorageItem = (IOxygenStorageItem)item2;
            return oxygenStorageItem.getOxygenStorage(item);
        }
        if (CompatibleManager.Create.isLoaded() && (storage = BacktankOxygenStorage.getOxygenStroage(item)) != null) {
            return storage;
        }
        return null;
    }

    public static long insert(LivingEntity living, long amount) {
        for (ItemStackReference item : LivingHelper.getSlotItems(living)) {
            if (amount <= 0L) break;
            if (!(item.getStack().m_41720_() instanceof OxygenCanItem)) continue;
            UniveralFluidHandler tank = UniveralFluidHandler.from(item);
            FluidHolder containedStack = tank.getFluidInTank(0);
            Fluid insertingFluid = (Fluid)ModFluids.OXYGEN.get();
            if (!containedStack.isEmpty()) {
                insertingFluid = containedStack.getFluid();
            }
            FluidHolder inserting = FluidHooks.newFluidHolder((Fluid)insertingFluid, (long)amount, null);
            long inserted = tank.insertFluid(inserting, false);
            amount -= inserted;
        }
        return amount;
    }

    private OxygenStorageUtils() {
    }
}

