/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blockcommands;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;

public interface ISerializer<T> {
    public Function<FriendlyByteBuf, T> getDeserializer();

    public BiConsumer<FriendlyByteBuf, T> getSerializer();

    public static class FluidStackSerializer
    implements ISerializer<FluidStack> {
        @Override
        public Function<FriendlyByteBuf, FluidStack> getDeserializer() {
            return IForgeFriendlyByteBuf::readFluidStack;
        }

        @Override
        public BiConsumer<FriendlyByteBuf, FluidStack> getSerializer() {
            return IForgeFriendlyByteBuf::writeFluidStack;
        }
    }

    public static class ItemStackSerializer
    implements ISerializer<ItemStack> {
        @Override
        public Function<FriendlyByteBuf, ItemStack> getDeserializer() {
            return FriendlyByteBuf::m_130267_;
        }

        @Override
        public BiConsumer<FriendlyByteBuf, ItemStack> getSerializer() {
            return FriendlyByteBuf::m_130055_;
        }
    }

    public static class BlockPosSerializer
    implements ISerializer<BlockPos> {
        @Override
        public Function<FriendlyByteBuf, BlockPos> getDeserializer() {
            return FriendlyByteBuf::m_130135_;
        }

        @Override
        public BiConsumer<FriendlyByteBuf, BlockPos> getSerializer() {
            return FriendlyByteBuf::m_130064_;
        }
    }

    public static class StringSerializer
    implements ISerializer<String> {
        @Override
        public Function<FriendlyByteBuf, String> getDeserializer() {
            return buf -> buf.m_130136_(Short.MAX_VALUE);
        }

        @Override
        public BiConsumer<FriendlyByteBuf, String> getSerializer() {
            return FriendlyByteBuf::m_130070_;
        }
    }

    public static class IntegerSerializer
    implements ISerializer<Integer> {
        @Override
        public Function<FriendlyByteBuf, Integer> getDeserializer() {
            return FriendlyByteBuf::readInt;
        }

        @Override
        public BiConsumer<FriendlyByteBuf, Integer> getSerializer() {
            return FriendlyByteBuf::writeInt;
        }
    }
}

