/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class ScreenControllerTileEntity
extends TickingTileEntity {
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(0).playerSlots(10, 70));
    public static final String COMPONENT_NAME = "screen_controller";
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)ScreenConfiguration.CONTROLLER_MAXENERGY.get()).intValue(), (long)((Integer)ScreenConfiguration.CONTROLLER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((BlockEntity)this));
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Screen Controller").containerSupplier(DefaultContainerProvider.container(ScreenModule.CONTAINER_SCREEN_CONTROLLER, CONTAINER_FACTORY, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private List<BlockPos> connectedScreens = new ArrayList<BlockPos>();
    private int tickCounter = 20;
    @ServerCommand
    public static final Command<?> CMD_SCAN = Command.create((String)"scan", (te, player, params) -> te.scan());
    @ServerCommand
    public static final Command<?> CMD_DETACH = Command.create((String)"detach", (te, player, params) -> te.detach());

    public ScreenControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ScreenModule.TYPE_SCREEN_CONTROLLER.get(), pos, state);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        int[] xes = tagCompound.m_128465_("screensx");
        int[] yes = tagCompound.m_128465_("screensy");
        int[] zes = tagCompound.m_128465_("screensz");
        this.connectedScreens.clear();
        for (int i = 0; i < xes.length; ++i) {
            this.connectedScreens.add(new BlockPos(xes[i], yes[i], zes[i]));
        }
        this.energyStorage.setEnergy(tagCompound.m_128454_("Energy"));
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        int[] xes = new int[this.connectedScreens.size()];
        int[] yes = new int[this.connectedScreens.size()];
        int[] zes = new int[this.connectedScreens.size()];
        for (int i = 0; i < this.connectedScreens.size(); ++i) {
            BlockPos c = this.connectedScreens.get(i);
            xes[i] = c.m_123341_();
            yes[i] = c.m_123342_();
            zes[i] = c.m_123343_();
        }
        tagCompound.m_128385_("screensx", xes);
        tagCompound.m_128385_("screensy", yes);
        tagCompound.m_128385_("screensz", zes);
        tagCompound.m_128356_("Energy", this.energyStorage.getEnergy());
    }

    protected void tickServer() {
        long rf;
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 20;
        long rememberRf = rf = this.energyStorage.getEnergy();
        boolean fixesAreNeeded = false;
        for (BlockPos c : this.connectedScreens) {
            BlockEntity te = this.f_58857_.m_7702_(c);
            if (te instanceof ScreenTileEntity) {
                ScreenTileEntity screen = (ScreenTileEntity)te;
                int rfModule = screen.getTotalRfPerTick() * 20;
                if ((long)rfModule > rf) {
                    screen.setPower(false);
                    continue;
                }
                rf -= (long)rfModule;
                screen.setPower(true);
                continue;
            }
            fixesAreNeeded = true;
        }
        if (rf < rememberRf) {
            this.energyStorage.consumeEnergy(rememberRf - rf);
        }
        if (fixesAreNeeded) {
            ArrayList<BlockPos> newScreens = new ArrayList<BlockPos>();
            for (BlockPos c : this.connectedScreens) {
                BlockEntity te = this.f_58857_.m_7702_(c);
                if (!(te instanceof ScreenTileEntity)) continue;
                newScreens.add(c);
            }
            this.connectedScreens = newScreens;
            this.m_6596_();
        }
    }

    private void scan() {
        this.detach();
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int radius = 32 + (int)(factor * 32.0f);
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        for (int y = yCoord - radius; y <= yCoord + radius; ++y) {
            if (y < this.f_58857_.m_141937_() || y >= this.f_58857_.m_151558_()) continue;
            for (int x = xCoord - radius; x <= xCoord + radius; ++x) {
                for (int z = zCoord - radius; z <= zCoord + radius; ++z) {
                    ScreenTileEntity ste;
                    BlockEntity te;
                    BlockPos spos = new BlockPos(x, y, z);
                    if (!(this.f_58857_.m_8055_(spos).m_60734_() instanceof ScreenBlock) || !((te = this.f_58857_.m_7702_(spos)) instanceof ScreenTileEntity) || (ste = (ScreenTileEntity)te).isConnected() || !ste.isControllerNeeded()) continue;
                    this.connectedScreens.add(spos);
                    ste.setConnected(true);
                }
            }
        }
        this.m_6596_();
    }

    public void detach() {
        for (BlockPos c : this.connectedScreens) {
            BlockEntity te = this.f_58857_.m_7702_(c);
            if (!(te instanceof ScreenTileEntity)) continue;
            ScreenTileEntity screen = (ScreenTileEntity)te;
            screen.setPower(false);
            screen.setConnected(false);
        }
        this.connectedScreens.clear();
        this.m_6596_();
    }

    public List<BlockPos> getConnectedScreens() {
        return this.connectedScreens;
    }
}

