/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.util;

import com.google.common.hash.Hashing;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Path;
import net.creeperhost.minetogether.MineTogetherPlatform;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.HashUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureVerifier {
    private static final Logger LOGGER = LogManager.getLogger();

    public static String generateSignature() {
        Path modJar;
        if (!Platform.isDevelopmentEnvironment() && System.getProperty("mt.develop.signature") == null && (modJar = MineTogetherPlatform.getModJar()) != null && modJar.toString().endsWith(".jar")) {
            try {
                return HashUtils.hash(Hashing.sha256(), modJar).toString();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to hash mod jar.", (Throwable)ex);
            }
        }
        return System.getProperty("mt.develop.signature", "Development");
    }
}

