/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.cap;

import com.google.common.collect.ImmutableList;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.cap.CapHandler;
import net.creeperhost.minetogether.repack.org.pircbotx.exception.CAPException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnableCapHandler
implements CapHandler {
    private static final Logger log = LogManager.getLogger(EnableCapHandler.class);
    protected final String cap;
    protected final boolean ignoreFail;

    public EnableCapHandler(String cap) {
        this.cap = cap;
        this.ignoreFail = false;
    }

    @Override
    public boolean handleLS(PircBotX bot, ImmutableList<String> capabilities) throws CAPException {
        if (capabilities.contains((Object)this.cap)) {
            if (PircBotX.DEBUG_LEVEL != null) {
                log.log(PircBotX.DEBUG_LEVEL, "Supported capability " + this.cap);
            }
            bot.sendCAP().request(this.cap);
            return false;
        }
        if (!this.ignoreFail) {
            throw new CAPException(CAPException.Reason.UNSUPPORTED_CAPABILITY, this.cap);
        }
        if (PircBotX.DEBUG_LEVEL != null) {
            log.log(PircBotX.DEBUG_LEVEL, "Unsupported capability " + this.cap);
        }
        return true;
    }

    @Override
    public boolean handleACK(PircBotX bot, ImmutableList<String> capabilities) throws CAPException {
        return capabilities.contains((Object)this.cap);
    }

    @Override
    public boolean handleNAK(PircBotX bot, ImmutableList<String> capabilities) throws CAPException {
        if (capabilities.contains((Object)this.cap)) {
            bot.getEnabledCapabilities().remove(this.cap);
            if (!this.ignoreFail) {
                throw new CAPException(CAPException.Reason.UNSUPPORTED_CAPABILITY, this.cap);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleUnknown(PircBotX bot, String rawLine) {
        return false;
    }

    public EnableCapHandler(String cap, boolean ignoreFail) {
        this.cap = cap;
        this.ignoreFail = ignoreFail;
    }

    public String toString() {
        return "EnableCapHandler(cap=" + this.getCap() + ", ignoreFail=" + this.ignoreFail + ")";
    }

    public String getCap() {
        return this.cap;
    }
}

