/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

public enum UserLevel {
    VOICE("+"),
    HALFOP("%"),
    OP("@"),
    SUPEROP("&"),
    OWNER("~");

    private final String symbol;

    public static String getSymbols() {
        StringBuilder symbols = new StringBuilder();
        for (UserLevel curLevel : UserLevel.values()) {
            symbols.append(curLevel.getSymbol());
        }
        return symbols.toString();
    }

    public static UserLevel fromSymbol(char symbol) {
        for (UserLevel curLevel : UserLevel.values()) {
            if (!curLevel.getSymbol().contains(String.valueOf(symbol))) continue;
            return curLevel;
        }
        return null;
    }

    private UserLevel(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }
}

