/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.net.okhttp;

import java.io.IOException;
import net.creeperhost.minetogether.repack.net.covers1624.quack.annotation.Requires;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.okhttp.HasherWrappedSource;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.okhttp.SniffingResponseBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.MultiHasher;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Requires.RequiresList(value={@Requires(value="com.google.guava:guava"), @Requires(value="com.squareup.okhttp3:okhttp")})
public class MultiHasherInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        MultiHasher hasher = (MultiHasher)request.tag(MultiHasher.class);
        Response response = chain.proceed(request);
        if (hasher == null) {
            return response;
        }
        ResponseBody body = response.body();
        if (body == null) {
            return response;
        }
        return response.newBuilder().body(SniffingResponseBody.ofFunction(body, source -> new HasherWrappedSource((Source)source, hasher))).build();
    }
}

