/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.apache;

import java.io.IOException;
import java.io.InputStream;
import net.creeperhost.minetogether.repack.net.covers1624.quack.annotation.Requires;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.EngineRequest;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.EngineResponse;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.HeaderList;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.WebBody;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.annotations.Nullable;

@Requires.RequiresList(value={@Requires(value="org.apache.httpcomponents:httpclient"), @Requires(value="org.apache.httpcomponents:httpmime", optional="Required if using MultipartBody.")})
public class ApacheEngineResponse
implements EngineResponse {
    private final EngineRequest request;
    private final CloseableHttpResponse response;
    private final HeaderList headers = new HeaderList();
    @Nullable
    private final WebBody body;

    public ApacheEngineResponse(EngineRequest request, CloseableHttpResponse response) {
        this.request = request;
        this.response = response;
        for (Header header : response.getAllHeaders()) {
            this.headers.add(header.getName(), header.getValue());
        }
        HttpEntity entity = response.getEntity();
        this.body = entity != null ? new ResponseBodyWrapper(entity) : null;
    }

    @Override
    public EngineRequest request() {
        return this.request;
    }

    @Override
    public int statusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String message() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public HeaderList headers() {
        return this.headers;
    }

    @Override
    public WebBody body() {
        return this.body;
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }

    private static class ResponseBodyWrapper
    implements WebBody {
        private final HttpEntity entity;
        @Nullable
        private final String contentType;

        private ResponseBodyWrapper(HttpEntity entity) {
            this.entity = entity;
            Header contentType = entity.getContentType();
            this.contentType = contentType != null ? contentType.getValue() : null;
        }

        @Override
        public InputStream open() throws IOException {
            return this.entity.getContent();
        }

        @Override
        public boolean multiOpenAllowed() {
            return this.entity.isRepeatable();
        }

        @Override
        public long length() {
            return this.entity.getContentLength();
        }

        @Override
        @Nullable
        public String contentType() {
            return this.contentType;
        }
    }
}

