/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.creeperhost.minetogether.repack.net.covers1624.quack.annotation.Requires;
import net.creeperhost.minetogether.repack.net.covers1624.quack.io.IOUtils;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.AbstractEngineRequest;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.EngineRequest;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.EngineResponse;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.HeaderList;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.MultipartBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.WebBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.apache.ApacheEngine;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.apache.ApacheEngineResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.jetbrains.annotations.Nullable;

@Requires.RequiresList(value={@Requires(value="org.apache.httpcomponents:httpclient"), @Requires(value="org.apache.httpcomponents:httpmime", optional="Required if using MultipartBody.")})
public class ApacheEngineRequest
extends AbstractEngineRequest {
    private final ApacheEngine engine;
    @Nullable
    private RequestBuilder builder;
    private final HeaderList headers = new HeaderList();

    public ApacheEngineRequest(ApacheEngine engine) {
        this.engine = engine;
    }

    @Override
    public EngineRequest method(String method, final @Nullable WebBody body) {
        assert (this.builder == null) : "Method already set";
        this.builder = RequestBuilder.create((String)method);
        if (body != null) {
            if (!(body instanceof MultipartBody)) {
                this.builder.setEntity((HttpEntity)new AbstractHttpEntity(){
                    {
                        this.setContentType(body.contentType());
                    }

                    public void writeTo(OutputStream os) throws IOException {
                        try (InputStream is = this.getContent();){
                            IOUtils.copy(is, os);
                        }
                    }

                    public boolean isRepeatable() {
                        return false;
                    }

                    public long getContentLength() {
                        return body.length();
                    }

                    public InputStream getContent() throws IOException, UnsupportedOperationException {
                        return body.open();
                    }

                    public boolean isStreaming() {
                        return true;
                    }
                });
            } else {
                this.builder.setEntity(ApacheEngineRequest.multipartBody((MultipartBody)body));
            }
        }
        return this;
    }

    private static HttpEntity multipartBody(MultipartBody body) {
        MultipartEntityBuilder multipartBuilder = MultipartEntityBuilder.create();
        for (final MultipartBody.Part part : body.getParts()) {
            ContentType contentType = null;
            String contentTypeString = part.body.contentType();
            if (contentTypeString != null) {
                contentType = ContentType.parse((String)contentTypeString);
            }
            multipartBuilder.addPart(part.name, (ContentBody)new AbstractContentBody(contentType){

                public String getTransferEncoding() {
                    return "binary";
                }

                public long getContentLength() {
                    return part.body.length();
                }

                public String getFilename() {
                    return part.fileName;
                }

                public void writeTo(OutputStream os) throws IOException {
                    try (InputStream is = part.body.open();){
                        IOUtils.copy(is, os);
                    }
                }
            });
        }
        return multipartBuilder.build();
    }

    @Override
    protected void assertState() {
        super.assertState();
        if (this.builder == null) {
            throw new IllegalStateException("method(String, Body) must be called first");
        }
    }

    @Override
    public EngineRequest url(String url) {
        super.url(url);
        this.builder.setUri(url);
        return this;
    }

    @Override
    public EngineResponse execute() throws IOException {
        this.assertState();
        if (this.url == null) {
            throw new IllegalStateException("Url not set.");
        }
        for (HeaderList.Entry header : this.headers) {
            this.builder.addHeader(header.name, header.value);
        }
        this.executed = true;
        HttpUriRequest uriRequest = this.builder.build();
        CloseableHttpResponse response = this.engine.getClient().execute(uriRequest);
        return new ApacheEngineResponse(this, response);
    }
}

