/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.blue.endless.jankson.impl;

import net.creeperhost.minetogether.repack.blue.endless.jankson.Jankson;
import net.creeperhost.minetogether.repack.blue.endless.jankson.JsonArray;
import net.creeperhost.minetogether.repack.blue.endless.jankson.api.SyntaxError;
import net.creeperhost.minetogether.repack.blue.endless.jankson.impl.ElementParserContext;
import net.creeperhost.minetogether.repack.blue.endless.jankson.impl.ParserContext;

public class ArrayParserContext
implements ParserContext<JsonArray> {
    private JsonArray result = new JsonArray();
    private boolean foundClosingBrace = false;

    @Override
    public boolean consume(int codePoint, Jankson loader) throws SyntaxError {
        this.result.setMarshaller(loader.getMarshaller());
        if (this.foundClosingBrace) {
            return false;
        }
        if (Character.isWhitespace(codePoint) || codePoint == 44) {
            return true;
        }
        if (codePoint == 93) {
            this.foundClosingBrace = true;
            return true;
        }
        loader.push(new ElementParserContext(), it -> {
            if (it.getElement() != null) {
                this.result.add(it.getElement(), it.getComment());
            } else {
                String existing = this.result.getComment(this.result.size() - 1);
                if (existing == null) {
                    existing = "";
                }
                String combined = existing + "\n" + it.getComment();
                this.result.setComment(this.result.size() - 1, combined);
            }
        });
        return false;
    }

    @Override
    public void eof() throws SyntaxError {
        if (this.foundClosingBrace) {
            return;
        }
        throw new SyntaxError("Unexpected end-of-file in the middle of a list! Are you missing a ']'?");
    }

    @Override
    public boolean isComplete() {
        return this.foundClosingBrace;
    }

    @Override
    public JsonArray getResult() throws SyntaxError {
        return this.result;
    }
}

