/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.blue.endless.jankson;

public class JsonGrammar {
    public static final JsonGrammar JANKSON = JsonGrammar.builder().bareSpecialNumerics(true).build();
    public static final JsonGrammar JSON5 = JsonGrammar.builder().withComments(true).printTrailingCommas(true).bareSpecialNumerics(true).build();
    public static final JsonGrammar STRICT = JsonGrammar.builder().withComments(false).build();
    public static final JsonGrammar COMPACT = JsonGrammar.builder().withComments(false).printWhitespace(false).bareSpecialNumerics(true).build();
    protected boolean comments = true;
    protected boolean printWhitespace = true;
    protected boolean printCommas = true;
    protected boolean printTrailingCommas = false;
    protected boolean bareSpecialNumerics = false;
    protected boolean bareRootObject = false;
    protected boolean printUnquotedKeys = false;

    public boolean hasComments() {
        return this.comments;
    }

    public boolean shouldOutputWhitespace() {
        return this.printWhitespace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JsonGrammar grammar = new JsonGrammar();

        public Builder withComments(boolean comments) {
            this.grammar.comments = comments;
            return this;
        }

        public Builder printWhitespace(boolean whitespace) {
            this.grammar.printWhitespace = whitespace;
            return this;
        }

        public Builder printCommas(boolean commas) {
            this.grammar.printCommas = commas;
            return this;
        }

        public Builder printTrailingCommas(boolean trailing) {
            this.grammar.printTrailingCommas = trailing;
            return this;
        }

        public Builder bareSpecialNumerics(boolean bare) {
            this.grammar.bareSpecialNumerics = bare;
            return this;
        }

        public Builder bareRootObject(boolean bare) {
            this.grammar.bareRootObject = bare;
            return this;
        }

        public Builder printUnquotedKeys(boolean unquoted) {
            this.grammar.printUnquotedKeys = unquoted;
            return this;
        }

        public JsonGrammar build() {
            return this.grammar;
        }
    }
}

