/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.creeperhost.minetogether.polylib.gui.PolyToast;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class SimpleToast
extends PolyToast {
    private final Component title;
    private final Component description;
    private ItemStack displayIconStack = ItemStack.f_41583_;
    private ResourceLocation iconResourceLocation;

    public SimpleToast(Component title) {
        this(title, (Component)Component.m_237119_());
    }

    public SimpleToast(Component title, ResourceLocation resourceLocation) {
        this(title, (Component)Component.m_237119_());
        this.iconResourceLocation = resourceLocation;
    }

    public SimpleToast(Component title, Component description) {
        this.title = title;
        this.description = description;
    }

    public SimpleToast(Component title, Component description, ItemStack itemStack) {
        this.title = title;
        this.description = description;
        this.displayIconStack = itemStack;
    }

    public SimpleToast(Component title, Component description, ResourceLocation resourceLocation) {
        this.title = title;
        this.description = description;
        this.iconResourceLocation = resourceLocation;
    }

    @Override
    public Toast.Visibility m_7172_(PoseStack poseStack, ToastComponent toastComponent, long l) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_94893_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toastComponent.m_93228_(poseStack, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
        if (this.iconResourceLocation != null) {
            this.renderImage(poseStack, toastComponent, this.iconResourceLocation);
        }
        if (this.title != null) {
            Font font = toastComponent.m_94929_().f_91062_;
            List titleList = font.m_92923_((FormattedText)this.title, 125);
            List descList = font.m_92923_((FormattedText)this.description, 125);
            boolean titleOnly = this.description.getString().isEmpty();
            int n = 0xFF88FF;
            if (descList.size() == 1 && titleList.size() == 1) {
                font.m_92889_(poseStack, this.title, 30.0f, 7.0f, n | 0xFF000000);
                font.m_92877_(poseStack, (FormattedCharSequence)descList.get(0), 30.0f, 18.0f, -1);
            } else if (l < 1500L || titleOnly) {
                int n2 = this.m_94899_() / 2;
                int n3 = titleList.size();
                Objects.requireNonNull(font);
                int yPos = n2 - n3 * 9 / 2;
                int alpha = titleOnly ? -16777216 : Mth.m_14143_((float)(Mth.m_14036_((float)((float)(1500L - l) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
                for (FormattedCharSequence formattedCharSequence : titleList) {
                    font.m_92877_(poseStack, formattedCharSequence, 30.0f, (float)yPos, n | alpha);
                    Objects.requireNonNull(font);
                    yPos += 9;
                }
            } else {
                int n4 = this.m_94899_() / 2;
                int n5 = descList.size();
                Objects.requireNonNull(font);
                int yPos = n4 - n5 * 9 / 2;
                int alpha = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(l - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
                for (FormattedCharSequence formattedCharSequence : descList) {
                    font.m_92877_(poseStack, formattedCharSequence, 30.0f, (float)yPos, 0xFFFFFF | alpha);
                    Objects.requireNonNull(font);
                    yPos += 9;
                }
            }
            if (!this.displayIconStack.m_41619_()) {
                toastComponent.m_94929_().m_91291_().m_115218_(this.displayIconStack, 8, 8);
            }
            return l >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

