/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class RadioButton
extends Button {
    private final List<Button.OnPress> actions = new LinkedList<Button.OnPress>();
    private float textScale = 1.0f;
    private boolean verticalText = false;
    private int autoScaleMargins = -1;
    private Supplier<Boolean> selected = () -> false;
    private Runnable onRelease = () -> {};

    public RadioButton(int x, int y, int width, int height, Component text) {
        super(x, y, width, height, text, e -> {});
    }

    public void updateBounds(int x, int y, int width, int height) {
        this.f_93620_ = x;
        this.f_93621_ = y;
        this.f_93618_ = width;
        this.f_93619_ = height;
    }

    public RadioButton onRelease(Runnable onRelease) {
        this.onRelease = onRelease;
        return this;
    }

    public RadioButton withAutoScaleText(int autoScaleMargins) {
        this.autoScaleMargins = autoScaleMargins;
        return this;
    }

    public RadioButton withTextScale(float scale) {
        this.textScale = scale;
        return this;
    }

    public RadioButton withVerticalText() {
        this.verticalText = true;
        return this;
    }

    public RadioButton onPressed(Button.OnPress action) {
        this.actions.add(action);
        return this;
    }

    public RadioButton selectedSupplier(Supplier<Boolean> selected) {
        this.selected = selected;
        return this;
    }

    public void m_5691_() {
        if (this.selected.get().booleanValue()) {
            return;
        }
        for (Button.OnPress action : this.actions) {
            action.m_93750_((Button)this);
        }
    }

    public boolean m_6348_(double d, double e, int i) {
        this.onRelease.run();
        return super.m_6348_(d, e, i);
    }

    public void m_6305_(PoseStack pStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        this.f_93622_ = this.isPressed() || mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
        int textColor = 0xFFFFFF;
        int fillColor = 1679826976;
        if (this.f_93622_ || this.isPressed()) {
            textColor = 0xFFFFA0;
            fillColor = Integer.MIN_VALUE;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RadioButton.m_93172_((PoseStack)pStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)fillColor);
        Font font = Minecraft.m_91087_().f_91062_;
        float scale = this.textScale;
        Objects.requireNonNull(font);
        double lHeight = 9.0f * scale;
        double lWidth = (float)font.m_92852_((FormattedText)this.m_6035_()) * scale;
        int autoWidth = (this.verticalText ? this.f_93619_ : this.f_93618_) - this.autoScaleMargins * 2;
        if (this.autoScaleMargins > -1 && lWidth > (double)autoWidth) {
            scale = (float)((double)scale * ((double)autoWidth / lWidth));
            Objects.requireNonNull(font);
            lHeight = 9.0f * scale;
            lWidth = (float)font.m_92852_((FormattedText)this.m_6035_()) * scale;
        }
        pStack.m_85836_();
        if (this.verticalText) {
            pStack.m_85837_((double)this.f_93620_ + lHeight + (double)this.f_93618_ / 2.0 - lHeight / 2.0, (double)this.f_93621_ + (double)this.f_93619_ / 2.0 - lWidth / 2.0, 0.0);
            pStack.m_85845_(new Quaternion(0.0f, 0.0f, 90.0f, true));
        } else {
            pStack.m_85837_((double)this.f_93620_ + (double)this.f_93618_ / 2.0 - lWidth / 2.0, (double)this.f_93621_ + (double)this.f_93619_ / 2.0 - lHeight / 2.0, 0.0);
        }
        pStack.m_85841_(scale, scale, scale);
        RadioButton.m_93243_((PoseStack)pStack, (Font)font, (Component)this.m_6035_(), (int)0, (int)0, (int)textColor);
        pStack.m_85849_();
    }

    public boolean isPressed() {
        return this.selected.get();
    }
}

