/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform.elements;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.gui.dialogs.ItemSelectDialog;
import net.creeperhost.minetogether.orderform.OrderGui;
import net.creeperhost.minetogether.orderform.OrderRequests;
import net.creeperhost.minetogether.orderform.requests.PostLoginRequest;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.TextState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstraintImpl;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DetailsElement
extends GuiElement<DetailsElement> {
    private final OrderGui gui;
    public volatile boolean loginMode = false;
    private boolean loggingIn = false;
    public boolean loggedIn = false;
    private String loggingInError = "";
    public String confirmPassword = "";

    public DetailsElement(@NotNull GuiParent<?> parent, OrderGui gui) {
        super(parent);
        this.gui = gui;
        GuiElement lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.m_237115_((String)"minetogether:gui.order.details").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        ConstraintImpl.MidPoint centerLeft = Constraint.midPoint((GeoRef)this.get(GeoParam.LEFT), (GeoRef)this.get(GeoParam.RIGHT), (double)-1.0);
        ConstraintImpl.MidPoint centerRight = Constraint.midPoint((GeoRef)this.get(GeoParam.LEFT), (GeoRef)this.get(GeoParam.RIGHT), (double)1.0);
        GuiElement email = (GuiElement)this.emailBox((Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)), (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement password = (GuiElement)this.passwordBox((Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)), (Constraint)centerLeft, TextState.create(() -> gui.order.password, val -> {
            gui.order.password = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.password")).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)email.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement password2 = (GuiElement)this.passwordBox((Constraint)centerRight, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)), TextState.create(() -> this.confirmPassword, val -> {
            this.confirmPassword = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.password_confirm")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)email.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement firstName = (GuiElement)this.detailsBox((Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)), (Constraint)centerLeft, TextState.create(() -> gui.order.firstName, val -> {
            gui.order.firstName = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.first_name")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)password.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement lastName = (GuiElement)this.detailsBox((Constraint)centerRight, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)), TextState.create(() -> gui.order.lastName, val -> {
            gui.order.lastName = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.last_name")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)password.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement address = (GuiElement)this.detailsBox((Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)), (Constraint)centerLeft, TextState.create(() -> gui.order.address, val -> {
            gui.order.address = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.address")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)firstName.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement city = (GuiElement)this.detailsBox((Constraint)centerRight, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)), TextState.create(() -> gui.order.city, val -> {
            gui.order.city = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.city")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)firstName.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement zipCode = (GuiElement)this.detailsBox((Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)), (Constraint)centerLeft, TextState.create(() -> gui.order.zip, val -> {
            gui.order.zip = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.zip")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)address.get(GeoParam.BOTTOM), (double)4.0));
        GuiElement state = (GuiElement)this.detailsBox((Constraint)centerRight, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)), TextState.create(() -> gui.order.state, val -> {
            gui.order.state = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.state")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)address.get(GeoParam.BOTTOM), (double)4.0));
        Map<String, OrderGui.Country> countryMap = this.getCountries();
        GuiButton country = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(this, () -> Component.m_237113_((String)gui.getSelectedCountry().toString())).setEnabled(() -> !this.loginMode)).onPress(() -> new ItemSelectDialog<OrderGui.Country>((GuiParent<?>)this.getModularGui().getRoot(), (Component)Component.m_237115_((String)"minetogether:gui.order.select_country"), new ArrayList(countryMap.values()), (OrderGui.Country)countryMap.get(gui.order.country)).setOnItemSelected(item -> {
            gui.order.country = item.key();
            gui.summaryDirty();
        })).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)zipCode.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)centerLeft)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiElement phone = (GuiElement)this.detailsBox((Constraint)centerRight, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)), TextState.create(() -> gui.order.phone, val -> {
            gui.order.phone = val;
        }), (Component)Component.m_237115_((String)"minetogether.info.phone")).setEnabled(() -> !this.loginMode).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)zipCode.get(GeoParam.BOTTOM), (double)4.0));
        GuiButton login = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(this, (Component)Component.m_237115_((String)"minetogether:gui.button.login")).setEnabled(() -> this.loginMode)).onPress(this::doLogin).setDisabled(() -> gui.order.password.isEmpty() || this.loggingIn || this.loggedIn).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)email.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)centerRight)).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiText loginInfo = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.m_237119_()).setEnabled(() -> this.loginMode)).setWrap(true).setTextSupplier(() -> {
            if (this.loggingIn) {
                return Component.m_237115_((String)"minetogether:gui.order.logging_in");
            }
            if (this.loggedIn) {
                return Component.m_237115_((String)"minetogether:gui.order.login_success");
            }
            if (!this.loggingInError.isEmpty()) {
                return Component.m_237110_((String)"minetogether:gui.order.login_error", (Object[])new Object[]{this.loggingInError});
            }
            return Component.m_237115_((String)"minetogether:gui.order.account_exists");
        }).setAlignment(Align.CENTER).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)login.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).autoHeight();
        this.constrain(GeoParam.BOTTOM, (Constraint)Constraint.dynamic(() -> this.loginMode ? loginInfo.yMax() : country.yMax()));
    }

    private GuiElement<?> emailBox(Constraint left, Constraint right) {
        GuiElement background = (GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(this).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiRectangle highlight = new GuiRectangle((GuiParent)background).border(0x50FFFFFF).fill(0x30FFFFFF);
        Constraints.bind((ConstrainedGeometry)highlight, (ConstrainedGeometry)background);
        GuiTextField textField = new GuiTextField((GuiParent)background).setSuggestion((Component)Component.m_237115_((String)"minetogether.info.e_mail")).setTextState(TextState.create(() -> this.gui.order.emailAddress, s -> {
            this.gui.order.emailAddress = s;
            this.gui.emailDirty();
        }));
        textField.setSuggestionColour(() -> 0xFFFFFF);
        highlight.setEnabled(() -> ((GuiTextField)textField).isFocused());
        Constraints.bind((ConstrainedGeometry)textField, (ConstrainedGeometry)background, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        return background;
    }

    private GuiElement<?> passwordBox(Constraint left, Constraint right, TextState textState, Component suggestion) {
        GuiElement background = (GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(this).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiRectangle highlight = new GuiRectangle((GuiParent)background).border(0x50FFFFFF).fill(0x30FFFFFF);
        Constraints.bind((ConstrainedGeometry)highlight, (ConstrainedGeometry)background);
        GuiTextField textField = new GuiTextField((GuiParent)background).setSuggestion(suggestion).setFormatter((s, integer) -> Component.m_237113_((String)StringUtils.repeat((char)'*', (int)s.length())).m_7532_()).setTextState(textState);
        textField.setSuggestionColour(() -> 0xFFFFFF);
        highlight.setEnabled(() -> ((GuiTextField)textField).isFocused());
        Constraints.bind((ConstrainedGeometry)textField, (ConstrainedGeometry)background, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        return background;
    }

    private GuiElement<?> detailsBox(Constraint left, Constraint right, TextState textState, Component suggestion) {
        GuiElement background = (GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(this).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiRectangle highlight = new GuiRectangle((GuiParent)background).border(0x50FFFFFF).fill(0x30FFFFFF);
        Constraints.bind((ConstrainedGeometry)highlight, (ConstrainedGeometry)background);
        GuiTextField textField = new GuiTextField((GuiParent)background).setSuggestion(suggestion).setTextState(textState);
        textField.setSuggestionColour(() -> 0xFFFFFF);
        highlight.setEnabled(() -> ((GuiTextField)textField).isFocused());
        Constraints.bind((ConstrainedGeometry)textField, (ConstrainedGeometry)background, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        return background;
    }

    private Map<String, OrderGui.Country> getCountries() {
        LinkedHashMap<String, OrderGui.Country> map = new LinkedHashMap<String, OrderGui.Country>();
        Countries.COUNTRIES.forEach((key, name) -> map.put((String)key, new OrderGui.Country((String)key, (String)name)));
        return map;
    }

    public void doLogin() {
        this.loggingIn = true;
        CompletableFuture.runAsync(() -> {
            PostLoginRequest.Response result = OrderRequests.doLogin(this.gui.order.emailAddress, this.gui.order.password);
            if (result.getStatus().equals("success")) {
                this.gui.order.currency = result.currency != null ? result.currency : "1";
                this.gui.order.clientID = result.userid != null ? result.userid : "98874";
                this.loggingIn = false;
                this.loggedIn = true;
                this.loggingInError = "";
                this.gui.summaryDirty();
            } else {
                this.loggingIn = false;
                this.loggedIn = false;
                this.loggingInError = result.getMessage();
            }
        }, OrderGui.EXECUTOR);
    }
}

