/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin.chat;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URL;
import java.util.Objects;
import net.creeperhost.minetogether.chat.ChatConstants;
import net.creeperhost.minetogether.chat.ChatStatistics;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.FriendChatNotifier;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.ChatScreenInjection;
import net.creeperhost.minetogether.chat.gui.FriendChatGui;
import net.creeperhost.minetogether.chat.ingame.MTChatComponent;
import net.creeperhost.minetogether.config.LocalConfig;
import net.creeperhost.minetogether.gui.PreviewElement;
import net.creeperhost.minetogether.gui.SettingGui;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.polylib.gui.IconButton;
import net.creeperhost.minetogether.polylib.gui.RadioButton;
import net.creeperhost.minetogether.polylib.gui.SlideButton;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiInjector;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
abstract class ChatScreenMixin
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private RadioButton vanillaChatButton;
    private RadioButton mtChatButton;
    private RadioButton groupChatButton;
    private SlideButton chatScaleSlider;
    private SlideButton chatWidthSlider;
    private SlideButton chatHeightSlider;
    private IconButton settingsButton;
    @Nullable
    private Message clickedMessage;
    @Shadow
    protected EditBox f_95573_;
    @Shadow
    CommandSuggestions f_95577_;
    @Shadow
    private String f_95576_;
    private Button newUserButton;
    private Button disableButton;

    @Shadow
    @Nullable
    protected abstract Style m_232701_(double var1, double var3);

    protected ChatScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        Minecraft mc = Minecraft.m_91087_();
        if (!LocalConfig.instance().chatEnabled || mc.f_91066_.f_92062_) {
            return;
        }
        ChatComponent chat = mc.f_91065_.m_93076_();
        float cScale = (float)chat.m_93815_();
        int cWidth = Mth.m_14167_((float)((float)chat.m_93813_() + 12.0f * cScale));
        int cHeight = Mth.m_14167_((float)((float)chat.m_93814_() * cScale));
        this.vanillaChatButton = ((RadioButton)this.m_142416_((GuiEventListener)new RadioButton(0, 0, 12, 100, (Component)(mc.m_91090_() ? Component.m_237115_((String)"minetogether:ingame.chat.local") : Component.m_237115_((String)"minetogether:ingame.chat.server"))))).withAutoScaleText(3).withVerticalText().selectedSupplier(() -> MineTogetherChat.getTarget() == ChatTarget.VANILLA).onPressed(e -> MineTogetherChat.setTarget(ChatTarget.VANILLA)).onRelease(() -> this.m_7522_((GuiEventListener)this.f_95573_));
        this.mtChatButton = ((RadioButton)this.m_142416_((GuiEventListener)new RadioButton(0, 0, 12, 100, (Component)Component.m_237115_((String)"minetogether:ingame.chat.global")))).withAutoScaleText(3).withVerticalText().selectedSupplier(() -> MineTogetherChat.getTarget() == ChatTarget.PUBLIC).onPressed(e -> MineTogetherChat.setTarget(ChatTarget.PUBLIC)).onRelease(() -> this.m_7522_((GuiEventListener)this.f_95573_));
        this.groupChatButton = ((RadioButton)this.m_142416_((GuiEventListener)new RadioButton(0, 0, 12, 100, (Component)Component.m_237115_((String)"minetogether:ingame.chat.group")))).withAutoScaleText(3).withVerticalText().selectedSupplier(() -> MineTogetherChat.getTarget() == ChatTarget.GROUP).onPressed(e -> MineTogetherChat.setTarget(ChatTarget.GROUP)).onRelease(() -> this.m_7522_((GuiEventListener)this.f_95573_));
        this.settingsButton = (IconButton)this.m_142416_((GuiEventListener)new IconButton(0, 0, 12, 12, new ResourceLocation("minetogether", "textures/gui/buttons/gear.png"), e -> mc.m_91152_((Screen)new SettingGui.Screen(mc.f_91080_))));
        this.chatScaleSlider = ((SlideButton)this.m_142416_((GuiEventListener)new SlideButton(0, 0, 12, 200))).setDynamicMessage(() -> Component.m_237110_((String)"options.percent_value", (Object[])new Object[]{Component.m_237115_((String)"options.chat.scale"), (int)((Double)mc.f_91066_.m_232110_().m_231551_() * 100.0)})).bindValue(() -> (Double)mc.f_91066_.m_232110_().m_231551_(), value -> {
            mc.f_91066_.m_232110_().m_231514_(value);
            this.updateButtons();
        }).setRange(0.25, 1.0).withTextScale(0.75f).onRelease(() -> this.m_7522_((GuiEventListener)this.f_95573_)).setEnabled(() -> this.f_95577_.f_93866_ == null && LocalConfig.instance().chatSettingsSliders).withAutoScaleText(3);
        this.chatWidthSlider = ((SlideButton)this.m_142416_((GuiEventListener)new SlideButton(0, 0, 12, 200))).setDynamicMessage(newValue -> Component.m_237110_((String)"options.pixel_value", (Object[])new Object[]{Component.m_237115_((String)"options.chat.width"), ChatComponent.m_93798_((double)newValue)})).bindValue(() -> (Double)mc.f_91066_.m_232113_().m_231551_(), value -> {
            mc.f_91066_.m_232113_().m_231514_(value);
            this.updateButtons();
        }).withTextScale(0.75f).onRelease(() -> this.m_7522_((GuiEventListener)this.f_95573_)).setApplyOnRelease(true).setEnabled(() -> this.f_95577_.f_93866_ == null && LocalConfig.instance().chatSettingsSliders).withAutoScaleText(3);
        this.chatHeightSlider = ((SlideButton)this.m_142416_((GuiEventListener)new SlideButton(0, 0, 12, 200))).setDynamicMessage(() -> Component.m_237110_((String)"options.pixel_value", (Object[])new Object[]{Component.m_237115_((String)"options.chat.height.focused"), ChatComponent.m_93811_((double)((Double)mc.f_91066_.m_232117_().m_231551_()))})).bindValue(() -> (Double)mc.f_91066_.m_232117_().m_231551_(), value -> {
            mc.f_91066_.m_232117_().m_231514_(value);
            this.updateButtons();
        }).withTextScale(0.75f).onRelease(() -> this.m_7522_((GuiEventListener)this.f_95573_)).setEnabled(() -> this.f_95577_.f_93866_ == null && LocalConfig.instance().chatSettingsSliders).withAutoScaleText(3);
        this.updateButtons();
        this.newUserButton = (Button)this.m_7787_((GuiEventListener)new Button(6, this.f_96544_ - (cHeight + 80) / 2 + 45, cWidth - 2, 20, (Component)Component.m_237113_((String)("Join " + ChatStatistics.onlineCount + " online users now!")), e -> MineTogetherChat.setNewUserResponded()));
        this.disableButton = (Button)this.m_7787_((GuiEventListener)new Button(6, this.f_96544_ - (cHeight + 80) / 2 + 70, cWidth - 2, 20, (Component)Component.m_237113_((String)"Don't ask me again."), e -> {
            MineTogetherChat.disableChat();
            LocalConfig.instance().chatEnabled = false;
            LocalConfig.save();
            MineTogetherChat.setNewUserResponded();
            this.m_169413_();
        }));
        this.newUserButton.f_93624_ = false;
        this.disableButton.f_93624_ = false;
        if (MineTogetherChat.isNewUser() && MineTogetherChat.getTarget() == ChatTarget.PUBLIC) {
            ChatStatistics.pollStats();
            this.newUserButton.f_93624_ = true;
            this.disableButton.f_93624_ = true;
        }
        this.switchToVanillaIfCommand();
        ModularGui gui = ModularGuiInjector.getActiveGui();
        if (gui != null && gui.getProvider() instanceof ChatScreenInjection) {
            ChatScreenInjection.setURLProvider(this::getUrlUnderMouse);
        }
    }

    private void updateButtons() {
        Minecraft mc = Minecraft.m_91087_();
        if (!LocalConfig.instance().chatEnabled || mc.f_91066_.f_92062_) {
            return;
        }
        ChatComponent chat = mc.f_91065_.m_93076_();
        float cScale = (float)chat.m_93815_();
        int cWidth = Mth.m_14167_((float)((float)chat.m_93813_() + 12.0f * cScale));
        int cHeight = Mth.m_14167_((float)((float)chat.m_93814_() * cScale)) - 12;
        int guiHeight = this.f_96544_;
        int cMaxYPos = guiHeight - 40;
        boolean groupChat = MineTogetherChat.CHAT_STATE.profileManager.getPrivateGroup() != null;
        int vanillaYPos = cMaxYPos - cHeight - 12;
        int vanillaHeight = groupChat ? cHeight / 3 : cHeight / 2;
        this.vanillaChatButton.updateBounds(cWidth, vanillaYPos, 12, vanillaHeight);
        int mtYPos = vanillaYPos + vanillaHeight;
        int mtHeight = groupChat ? cHeight / 3 : cMaxYPos - mtYPos - 12;
        this.mtChatButton.updateBounds(cWidth, mtYPos, 12, mtHeight);
        int groupYPos = mtYPos + mtHeight;
        int groupHeight = groupChat ? cMaxYPos - groupYPos - 12 : 0;
        this.groupChatButton.updateBounds(cWidth, groupYPos, 12, groupHeight);
        this.groupChatButton.f_93624_ = groupChat;
        this.settingsButton.updateBounds(cWidth, groupChat ? groupYPos + groupHeight : mtYPos + mtHeight, 12, 12);
        int sliderWidth = cWidth / 3;
        this.chatWidthSlider.updateBounds(0, cMaxYPos + 2, sliderWidth, 10);
        this.chatHeightSlider.updateBounds(sliderWidth + 2, cMaxYPos + 2, sliderWidth, 10);
        this.chatScaleSlider.updateBounds(sliderWidth * 2 + 4, cMaxYPos + 2, cWidth - sliderWidth * 2 - 4, 10);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        ClickEvent clickEvent;
        Style style = this.m_232701_(mouseX, mouseY);
        if (style != null && (clickEvent = style.m_131182_()) instanceof FriendChatNotifier.OpenFriendEvent) {
            FriendChatNotifier.OpenFriendEvent event = (FriendChatNotifier.OpenFriendEvent)clickEvent;
            FriendChatGui.setSelected(event.profile);
            Minecraft.m_91087_().m_91152_((Screen)new FriendChatGui.Screen(null));
            cir.setReturnValue((Object)true);
        }
        if (!LocalConfig.instance().chatEnabled || Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && button == 0 && style != null && this.m_5561_(style)) {
            this.f_95576_ = this.f_95573_.m_94155_();
            cir.setReturnValue((Object)true);
        }
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && this.tryClickMTChat(MineTogetherChat.publicChat, mouseX, mouseY)) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean m_6348_(double d, double e, int i) {
        Minecraft mc = Minecraft.m_91087_();
        if (!LocalConfig.instance().chatEnabled || mc.f_91066_.f_92062_) {
            return super.m_6348_(d, e, i);
        }
        this.chatWidthSlider.m_6348_(d, e, i);
        this.chatHeightSlider.m_6348_(d, e, i);
        this.chatScaleSlider.m_6348_(d, e, i);
        this.m_7522_((GuiEventListener)this.f_95573_);
        return super.m_6348_(d, e, i);
    }

    public boolean m_7920_(int i, int j, int k) {
        if (!LocalConfig.instance().chatEnabled || this.f_96541_.f_91066_.f_92062_) {
            return super.m_7920_(i, j, k);
        }
        this.m_7522_((GuiEventListener)this.f_95573_);
        return super.m_7920_(i, j, k);
    }

    public void m_94757_(double d, double e) {
        if (!LocalConfig.instance().chatEnabled || this.f_96541_.f_91066_.f_92062_) {
            super.m_94757_(d, e);
            return;
        }
        this.chatWidthSlider.mouseMove(d, e);
        this.chatHeightSlider.mouseMove(d, e);
        this.chatScaleSlider.mouseMove(d, e);
        super.m_94757_(d, e);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(PoseStack pStack, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && MineTogetherChat.isNewUser()) {
            pStack.m_85836_();
            pStack.m_85837_(0.0, 0.0, 100.0);
            MTChatComponent chatComponent = MineTogetherChat.publicChat;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            int y = this.f_96544_ - 43 - 9 * Math.max(Math.min(chatComponent.m_93797_().size(), chatComponent.m_93816_()), 20);
            ChatScreenMixin.m_93172_((PoseStack)pStack, (int)0, (int)y, (int)(chatComponent.m_93813_() + 6), (int)(chatComponent.m_93814_() + 10 + y), (int)-1728053248);
            ChatScreenMixin.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"minetogether:new_user.1"), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2), (int)0xFFFFFF);
            ChatScreenMixin.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"minetogether:new_user.2"), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 10), (int)0xFFFFFF);
            ChatScreenMixin.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"minetogether:new_user.3"), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 20), (int)0xFFFFFF);
            ChatScreenMixin.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)Component.m_237110_((String)"minetogether:new_user.4", (Object[])new Object[]{ChatStatistics.userCount}), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 30), (int)0xFFFFFF);
            this.newUserButton.m_6305_(pStack, mouseX, mouseY, partialTicks);
            this.disableButton.m_6305_(pStack, mouseX, mouseY, partialTicks);
            pStack.m_85849_();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.switchToVanillaIfCommand();
        if (this.groupChatButton != null && this.groupChatButton.f_93624_ == (MineTogetherChat.CHAT_STATE.profileManager.getPrivateGroup() == null)) {
            this.updateButtons();
        }
        if (MineTogetherChat.getTarget() == ChatTarget.VANILLA) {
            this.f_95573_.m_94186_(true);
            this.f_95573_.m_94167_("");
            return;
        }
        if (MineTogetherChat.isNewUser()) {
            this.newUserButton.f_93624_ = true;
            this.disableButton.f_93624_ = true;
            this.f_95573_.m_94178_(false);
            this.f_95573_.m_94186_(false);
            return;
        }
        IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
        if (state != IrcState.CONNECTED) {
            this.f_95573_.m_94178_(false);
            this.f_95573_.m_94186_(false);
            this.f_95573_.m_94167_(Component.m_237115_((String)ChatConstants.STATE_SUGGESTION_LOOKUP.get((Object)state)).getString());
            return;
        }
        this.f_95573_.m_94186_(true);
        this.f_95573_.m_94167_("");
    }

    private boolean tryClickMTChat(MTChatComponent mtChat, double mouseX, double mouseY) {
        ChatScreenInjection injection;
        GuiProvider guiProvider;
        if (!mtChat.handleClick(mouseX, mouseY)) {
            return false;
        }
        Message message = mtChat.getClickedMessage();
        if (message == null) {
            return false;
        }
        ModularGui gui = ModularGuiInjector.getActiveGui();
        if (gui != null && (guiProvider = gui.getProvider()) instanceof ChatScreenInjection && (injection = (ChatScreenInjection)guiProvider).canShowDialog()) {
            this.clickedMessage = message;
            mtChat.clearClickedMessage();
            injection.openMessageDialog(this.clickedMessage, this.f_95573_, mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Nullable
    private PreviewElement.URLInfo getUrlUnderMouse(double mouseX, double mouseY) {
        if (MineTogetherChat.getTarget() != ChatTarget.PUBLIC) {
            return null;
        }
        Style style = MineTogetherChat.publicChat.getStyleUnderMouse(mouseX, mouseY);
        URL url = PreviewElement.urlFromStyle(style);
        if (url == null) {
            return null;
        }
        Message message = MineTogetherChat.publicChat.getMessageUnderMouse(mouseX, mouseY);
        return new PreviewElement.URLInfo(url, message != null && message.sender == null);
    }

    @Inject(method={"handleChatInput"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleChatInput(String message, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        String normalized = this.m_232706_(message);
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && !normalized.isEmpty()) {
            MineTogetherChat.publicChat.m_93783_(message);
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract String m_232706_(String var1);

    @Inject(method={"sendsChatPreviewRequests"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendsChatPreviewRequests(CallbackInfoReturnable<Boolean> cir) {
        if (MineTogetherChat.getTarget() != ChatTarget.VANILLA) {
            cir.setReturnValue((Object)false);
        }
    }

    private boolean switchToVanillaIfCommand() {
        if (MineTogetherChat.getTarget() == ChatTarget.VANILLA) {
            return false;
        }
        if (!this.f_95573_.m_94155_().startsWith("/")) {
            return false;
        }
        MineTogetherChat.setTarget(ChatTarget.VANILLA);
        return true;
    }
}

