/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.profile;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcClient;
import net.creeperhost.minetogether.lib.chat.irc.IrcUser;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.request.AddFriendRequest;
import net.creeperhost.minetogether.lib.chat.request.IsBannedRequest;
import net.creeperhost.minetogether.lib.chat.request.ListFriendsRequest;
import net.creeperhost.minetogether.lib.chat.request.ListFriendsResponse;
import net.creeperhost.minetogether.lib.chat.request.ProfileRequest;
import net.creeperhost.minetogether.lib.chat.request.ProfileResponse;
import net.creeperhost.minetogether.lib.chat.request.RemoveFriendRequest;
import net.creeperhost.minetogether.lib.chat.util.HashLength;
import net.creeperhost.minetogether.lib.util.AbstractWeakNotifiable;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import net.creeperhost.minetogether.lib.web.FriendResponse;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.ColUtils;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.LazyValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class ProfileManager
extends AbstractWeakNotifiable<ProfileManagerEvent> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService FRIEND_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("MT Friends Thread %d").setDaemon(true).build());
    private final ScheduledExecutorService SCHEDULED_FRIEND_EXECUTOR = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("MT Scheduled Friends Update Thread %d").setDaemon(true).build());
    private final ScheduledExecutorService SCHEDULED_PROFILE_EXECUTOR = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("MT Scheduled Profile Update Thread %d").setDaemon(true).build());
    private final ExecutorService PROFILE_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("MT Profile Update Thread %d").setDaemon(true).build());
    private final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("MT Scheduled Profile Update Thread %d").setDaemon(true).build());
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final LazyValue<Profile> ownProfile;
    private final Map<String, FriendRequest> friendRequests = new LinkedHashMap<String, FriendRequest>();
    private final Map<String, FriendRequest> pendingFriends = new LinkedHashMap<String, FriendRequest>();
    private final Map<String, PrivateGroup> groupInvites = new LinkedHashMap<String, PrivateGroup>();
    private int friendCookie;
    private boolean friendUpdateRunning;
    private boolean checkingBanStatus;
    @Nullable
    private PrivateGroup privateGroup;

    public ProfileManager(String ownHash) {
        this.ownProfile = new LazyValue<Profile>(() -> this.lookupProfile(ownHash));
        this.startFriendsUpdater();
        this.startProfileUpdater();
    }

    protected void startFriendsUpdater() {
        this.SCHEDULED_FRIEND_EXECUTOR.scheduleAtFixedRate(this::updateFriends, 10L, 60L, TimeUnit.SECONDS);
    }

    protected void startProfileUpdater() {
        this.SCHEDULED_PROFILE_EXECUTOR.scheduleAtFixedRate(this::updateProfile, 5L, 10L, TimeUnit.SECONDS);
    }

    public abstract ChatState getChatState();

    public Profile getOwnProfile() {
        return this.ownProfile.get();
    }

    public void refreshOwnProfile() {
        Profile profile = this.getOwnProfile();
        profile.markStale();
        this.scheduleUpdate(profile);
    }

    public Profile lookupProfile(String hash) {
        Profile profile = this.lookupProfileStale(hash);
        if (profile.isStale() && !profile.isUpdating()) {
            this.scheduleUpdate(profile);
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile lookupProfileStale(String hash) {
        if (hash.isEmpty()) {
            throw new IllegalStateException("Empty hash provided. This should never happen!!");
        }
        Profile profile = this.profiles.get(hash);
        if (profile == null) {
            Map<String, Profile> map = this.profiles;
            synchronized (map) {
                String withoutMT;
                profile = this.profiles.get(hash);
                if (profile != null) {
                    return profile;
                }
                if (HashLength.FULL.matches(hash)) {
                    for (String alias : Profile.computeAllAliases(hash)) {
                        profile = this.profiles.get(alias);
                        if (profile == null) continue;
                        this.profiles.put(hash, profile);
                        return profile;
                    }
                }
                if (hash.charAt(0) == 'M' && (profile = this.profiles.get(withoutMT = hash.substring(2))) != null) {
                    this.profiles.put(hash, profile);
                    return profile;
                }
                profile = new Profile(this.getChatState(), hash);
                this.profiles.put(hash, profile);
                this.updateAliases(profile);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Profile> getKnownProfiles() {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            return FastStream.of(this.profiles.values()).distinct().toImmutableList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Profile> getMutedProfiles() {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            return FastStream.of(this.profiles.values()).distinct().filter(Profile::isMuted).toImmutableList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FriendRequest> getFriendRequests() {
        Map<String, FriendRequest> map = this.friendRequests;
        synchronized (map) {
            return ImmutableList.copyOf(this.friendRequests.values());
        }
    }

    public void sendFriendRequest(String friendCode, String desiredName, Consumer<Boolean> onComplete) {
        this.FRIEND_EXECUTOR.execute(() -> {
            try {
                FriendResponse resp = this.getChatState().api.execute(new AddFriendRequest(this.getOwnProfile().getFullHash(), friendCode, desiredName)).apiResponse();
                if (!resp.getStatus().equals("success")) {
                    LOGGER.error("Failed to send friend request. Api returned: {}", (Object)resp.getMessageOrNull());
                    onComplete.accept(false);
                    return;
                }
                if (resp.getHash() != null) {
                    Profile to = this.lookupProfile(resp.getHash());
                    this.notifyFriendRequest(to, desiredName);
                } else {
                    LOGGER.warn("Request did not return a user hash, Most likely because there was already an existing friend request.");
                }
                onComplete.accept(true);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to add Friend.", (Throwable)ex);
                onComplete.accept(false);
            }
        });
    }

    public void updateFriendName(Profile profile, String desiredName, Consumer<Boolean> onComplete) {
        if (!profile.hasFullHash()) {
            LOGGER.error("Unable to update friend name: Incomplete Profile.");
            onComplete.accept(false);
            return;
        }
        this.FRIEND_EXECUTOR.execute(() -> {
            try {
                FriendResponse resp = this.getChatState().api.execute(new AddFriendRequest(this.getOwnProfile().getFullHash(), profile.getFriendCode(), desiredName)).apiResponse();
                if (!resp.getStatus().equals("success")) {
                    LOGGER.error("Failed to update friend. Api returned: {}", (Object)resp.getMessageOrNull());
                    onComplete.accept(false);
                    return;
                }
                this.updateFriends();
                onComplete.accept(true);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to update Friend.", (Throwable)ex);
                onComplete.accept(false);
            }
        });
    }

    private boolean notifyFriendRequest(Profile to, String desiredName) {
        IrcUser ircUser = this.getChatState().ircClient.getUser(to);
        if (ircUser == null) {
            return false;
        }
        ircUser.sendFriendRequest(this.getOwnProfile().getFriendCode(), desiredName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIncomingFriendRequest(Profile from, String friendCode, String desiredName) {
        Map<String, FriendRequest> map = this.friendRequests;
        synchronized (map) {
            if (!from.isStale() && this.friendRequests.containsKey(from.getFullHash())) {
                return;
            }
            FriendRequest request = new FriendRequest(from, friendCode, desiredName);
            this.friendRequests.put(from.isStale() ? from.initialHash : from.getFullHash(), request);
            ++this.friendCookie;
            this.fire(new ProfileManagerEvent(EventType.FRIEND_REQUEST_ADDED, request));
        }
    }

    public boolean acceptFriendRequest(FriendRequest request, String desiredName) {
        this.FRIEND_EXECUTOR.execute(() -> {
            try {
                FriendResponse resp = this.getChatState().api.execute(new AddFriendRequest(this.getOwnProfile().getFullHash(), request.friendCode, desiredName)).apiResponse();
                if (!resp.getStatus().equals("success")) {
                    LOGGER.error("Failed to accept friend request. Api returned: {}", (Object)resp.getMessageOrNull());
                    return;
                }
                Profile from = request.user;
                if (from.isStale()) {
                    this.updateFriends();
                    return;
                }
                Map<String, FriendRequest> map = this.friendRequests;
                synchronized (map) {
                    this.friendRequests.remove(from.getFullHash());
                }
                this.updateFriends();
                this.notifyFriendAccepted(request);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to add Friend.", (Throwable)ex);
            }
        });
        return true;
    }

    private void notifyFriendAccepted(FriendRequest request) {
        IrcUser ircUser = this.getChatState().ircClient.getUser(request.user);
        if (ircUser == null) {
            return;
        }
        ircUser.acceptFriendRequest(this.getOwnProfile().getFriendCode(), request.desiredName);
    }

    public void onFriendRequestAccepted(Profile from, String friendCode, String desiredName) {
        this.FRIEND_EXECUTOR.execute(this::updateFriends);
        this.fire(new ProfileManagerEvent(EventType.FRIEND_REQUEST_ACCEPTED, from));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void denyFriendRequest(FriendRequest request) {
        Map<String, FriendRequest> map = this.friendRequests;
        synchronized (map) {
            this.removeFriend(request.user);
            if (!request.user.isStale()) {
                this.friendRequests.remove(request.user.getFullHash());
                ++this.friendCookie;
            }
        }
    }

    public void removeFriend(Profile friend) {
        friend.removeFriend();
        ++this.friendCookie;
        this.FRIEND_EXECUTOR.execute(() -> {
            try {
                ApiResponse resp = this.getChatState().api.execute(new RemoveFriendRequest(friend.getFullHash(), this.getOwnProfile().getFullHash())).apiResponse();
                if (!resp.getStatus().equals("success")) {
                    LOGGER.error("Failed to remove friend. Api returned: {}", (Object)resp.getMessageOrNull());
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to remove friend!", (Throwable)ex);
            }
        });
    }

    private void updateFriends() {
        if (this.friendUpdateRunning) {
            return;
        }
        this.friendUpdateRunning = true;
        try {
            ListFriendsResponse resp = this.getChatState().api.execute(new ListFriendsRequest(this.getOwnProfile().getFullHash())).apiResponse();
            boolean changes = false;
            HashSet<String> friendHashes = new HashSet<String>();
            for (ListFriendsResponse.FriendEntry friendEntry : resp.friends) {
                Profile profile;
                String hash = friendEntry.getHash();
                if (!HashLength.FULL.matches(hash)) {
                    LOGGER.warn("Ignoring friend '{}' with invalid hash. '{}'", (Object)friendEntry.getName(), (Object)hash);
                    continue;
                }
                friendHashes.add(hash);
                if (!friendEntry.isAccepted() || (profile = this.lookupProfile(hash)).isFriend() && friendEntry.getName().equals(profile.getFriendName())) continue;
                profile.setFriend(friendEntry.getName());
                changes = true;
            }
            for (Profile profile : this.getKnownProfiles()) {
                if (!profile.isFriend() || ColUtils.anyMatch(profile.getAliases(), alias -> friendHashes.contains(alias) || ColUtils.anyMatch(friendHashes, s -> s.startsWith((String)alias)))) continue;
                profile.removeFriend();
                changes = true;
            }
            LinkedHashMap<String, FriendRequest> pending = new LinkedHashMap<String, FriendRequest>();
            for (ListFriendsResponse.FriendEntry entry : resp.pending) {
                String hash = entry.getHash();
                if (!HashLength.FULL.matches(hash)) {
                    LOGGER.warn("Ignoring pending friend '{}' with invalid hash. '{}'", (Object)entry.getName(), (Object)hash);
                    continue;
                }
                Profile user = this.lookupProfile(hash);
                if (user.isStale()) {
                    LOGGER.warn("Ignoring pending friend '{}' profile is stale. '{}'", (Object)entry.getName(), (Object)hash);
                    continue;
                }
                pending.put(hash, new FriendRequest(user, user.getFriendCode(), entry.getName()));
            }
            changes |= this.pendingFriends.entrySet().removeIf(e -> !pending.containsKey(e.getKey()));
            for (String hash : pending.keySet()) {
                FriendRequest request = (FriendRequest)pending.get(hash);
                if (this.pendingFriends.containsKey(hash) && this.pendingFriends.get(hash).equals(request)) continue;
                this.pendingFriends.put(hash, request);
                changes = true;
            }
            LinkedHashMap<String, FriendRequest> linkedHashMap = new LinkedHashMap<String, FriendRequest>();
            for (ListFriendsResponse.FriendEntry entry : resp.requests) {
                String hash = entry.getHash();
                if (!HashLength.FULL.matches(hash)) {
                    LOGGER.warn("Ignoring friend request '{}' with invalid hash. '{}'", (Object)entry.getName(), (Object)hash);
                    continue;
                }
                Profile user = this.lookupProfile(hash);
                if (user.isStale()) {
                    LOGGER.warn("Ignoring friend friend '{}' profile is stale. '{}'", (Object)entry.getName(), (Object)hash);
                    continue;
                }
                linkedHashMap.put(hash, new FriendRequest(user, user.getFriendCode(), entry.getName()));
            }
            changes |= this.friendRequests.entrySet().removeIf(e -> !requests.containsKey(e.getKey()));
            for (String hash : linkedHashMap.keySet()) {
                FriendRequest request = (FriendRequest)linkedHashMap.get(hash);
                if (this.friendRequests.containsKey(hash) && this.friendRequests.get(hash).equals(request)) continue;
                this.friendRequests.put(hash, request);
                changes = true;
            }
            if (changes) {
                ++this.friendCookie;
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to query friend list.", ex);
        }
        this.friendUpdateRunning = false;
    }

    public int getFriendUpdateCookie() {
        return this.friendCookie;
    }

    public boolean isFriendUpdateRunning() {
        return this.friendUpdateRunning;
    }

    public void onUserOnline(Profile profile) {
        if (profile.isOnline) {
            return;
        }
        profile.isOnline = true;
        if (profile.isFriend()) {
            this.onFriendOnline(profile);
        }
    }

    void onFriendOnline(Profile profile) {
        this.fire(new ProfileManagerEvent(EventType.FRIEND_ONLINE, profile));
        IrcUser ircUser = this.getChatState().ircClient.getUser(profile);
        if (ircUser != null) {
            ircUser.sendRawCTCP("FRIENDUUID " + this.getChatState().auth.getUUID().toString());
        }
    }

    public void onUserOffline(Profile profile) {
        if (!profile.isOnline) {
            return;
        }
        profile.isOnline = false;
        if (profile.isFriend()) {
            this.fire(new ProfileManagerEvent(EventType.FRIEND_OFFLINE, profile));
        }
        if (profile.hasFullHash()) {
            for (String s : this.groupInvites.keySet()) {
                PrivateGroup group = this.groupInvites.get(s);
                if (!profile.getFullHash().equals(group.ownerHash)) continue;
                this.groupInvites.remove(s);
                ++this.friendCookie;
                break;
            }
        }
    }

    @Nullable
    public PrivateGroup getPrivateGroup() {
        return this.privateGroup;
    }

    public void sendGroupInvite(Profile target) {
        IrcClient client = this.getChatState().ircClient;
        Profile own = this.getOwnProfile();
        String channelName = "#" + own.getIrcName();
        this.FRIEND_EXECUTOR.execute(() -> {
            if (this.privateGroup != null && !this.privateGroup.channelName.equals(channelName)) {
                this.leaveGroup("starting_group");
            }
            this.privateGroup = new PrivateGroup(null, channelName);
            client.joinChannel(channelName);
            IrcUser user = client.getUser(target);
            if (user != null) {
                user.sendRawLine("INVITE MT" + target.getIrcName() + " " + channelName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptGroupInvite(PrivateGroup group) {
        Map<String, PrivateGroup> map = this.groupInvites;
        synchronized (map) {
            IrcClient client = this.getChatState().ircClient;
            this.groupInvites.remove(group.channelName);
            if (this.privateGroup != null && !this.privateGroup.channelName.equals(group.channelName)) {
                this.leaveGroup("switching_group");
            }
            this.privateGroup = group;
            client.joinChannel(group.channelName);
            ++this.friendCookie;
        }
    }

    public void leaveGroup(String reason) {
        if (this.privateGroup == null) {
            return;
        }
        IrcClient client = this.getChatState().ircClient;
        IrcChannel channel = client.getChannel(this.privateGroup.channelName);
        if (channel != null) {
            channel.part(reason);
        }
        this.privateGroup = null;
        this.fire(new ProfileManagerEvent(EventType.LEFT_GROUP, reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupInvite(PrivateGroup group) {
        Map<String, PrivateGroup> map = this.groupInvites;
        synchronized (map) {
            this.groupInvites.put(group.channelName, group);
            ++this.friendCookie;
            this.fire(new ProfileManagerEvent(EventType.GROUP_INVITE_RECEIVED, group));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PrivateGroup> getGroupInvites() {
        Map<String, PrivateGroup> map = this.groupInvites;
        synchronized (map) {
            return ImmutableList.copyOf(this.groupInvites.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectGroupInvite(PrivateGroup group) {
        Map<String, PrivateGroup> map = this.groupInvites;
        synchronized (map) {
            this.groupInvites.remove(group.channelName);
            ++this.friendCookie;
        }
    }

    private void scheduleUpdate(Profile profile) {
        Consumer<ProfileResponse.ProfileData> onFinished = profile.onStartUpdating().andThen(p -> this.updateAliases(profile));
        this.scheduleUpdate(profile, onFinished, 0);
        if (profile == this.getOwnProfile()) {
            this.checkBannedStatus(0);
        }
    }

    private void scheduleUpdate(Profile profile, Consumer<ProfileResponse.ProfileData> onFinished, int depth) {
        this.PROFILE_EXECUTOR.execute(() -> {
            try {
                ProfileResponse resp = this.getChatState().api.execute(new ProfileRequest(profile.initialHash)).apiResponse();
                if (resp.getStatus().equals("success")) {
                    ProfileResponse.ProfileData data = resp.getData(profile.initialHash);
                    if (data == null) {
                        LOGGER.error("Profile response did not return expected hash. Got: '{}' Expected: {}", resp.getDataKeys(), (Object)profile.initialHash);
                    } else {
                        onFinished.accept(data);
                        return;
                    }
                }
                if (!resp.getMessage().startsWith("Profile request already ongoing")) {
                    LOGGER.warn("Unexpected error response from API: " + resp.getMessage());
                }
            }
            catch (IOException ex) {
                LOGGER.warn("IOException whilst querying profile.", (Throwable)ex);
            }
            this.SCHEDULED_EXECUTOR.schedule(() -> this.scheduleUpdate(profile, onFinished, depth + 1), (long)(depth + 1), TimeUnit.MINUTES);
        });
    }

    private void checkBannedStatus(int depth) {
        Profile profile = this.getOwnProfile();
        this.PROFILE_EXECUTOR.execute(() -> {
            if (this.checkingBanStatus) {
                return;
            }
            this.checkingBanStatus = true;
            try {
                IsBannedRequest.Response resp = this.getChatState().api.execute(new IsBannedRequest(profile.initialHash)).apiResponse();
                if (resp.getStatus().equals("success")) {
                    Map<String, Profile> map = this.profiles;
                    synchronized (map) {
                        if (resp.banned && !profile.isBanned()) {
                            profile.banned();
                            this.getChatState().ircClient.stop();
                        } else if (!resp.banned && profile.isBanned()) {
                            profile.unbanned();
                            this.getChatState().ircClient.restart();
                        }
                    }
                    this.checkingBanStatus = false;
                    return;
                }
                LOGGER.warn("Unexpected error response from API: " + resp.getMessage());
            }
            catch (IOException ex) {
                LOGGER.warn("IOException whilst querying ban status.", (Throwable)ex);
            }
            this.SCHEDULED_EXECUTOR.schedule(() -> this.checkBannedStatus(depth + 1), (long)(depth + 1), TimeUnit.MINUTES);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAliases(Profile profile) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            for (String alias : profile.getAliases()) {
                Profile other;
                if (alias.equals(profile.initialHash) || (other = this.profiles.put(alias, profile)) == null || other == profile) continue;
                LOGGER.warn("Duplicate profiles with hash {}. A: {}, B: {}", (Object)alias, (Object)other.initialHash, (Object)profile.initialHash);
            }
        }
    }

    private void updateProfile() {
        Profile profile = this.getOwnProfile();
        if (profile.isStale() && !profile.isUpdating()) {
            this.scheduleUpdate(profile);
        }
        if (profile.isBanned()) {
            this.checkBannedStatus(0);
        }
        if (this.privateGroup != null && this.privateGroup.ownerHash != null) {
            IrcClient client = this.getChatState().ircClient;
            IrcChannel channel = client.getChannel(this.privateGroup.channelName);
            Profile owner = this.lookupProfile(this.privateGroup.ownerHash);
            if (channel != null && !channel.getUsers().contains(owner)) {
                this.leaveGroup("owner_left");
            }
        }
    }

    public static enum EventType {
        FRIEND_REQUEST_ADDED,
        FRIEND_REQUEST_ACCEPTED,
        FRIEND_ONLINE,
        FRIEND_OFFLINE,
        GROUP_INVITE_RECEIVED,
        LEFT_GROUP;

    }

    public static class PrivateGroup {
        @Nullable
        public final String ownerHash;
        public final String channelName;

        public PrivateGroup(@Nullable String ownerHash, String channelName) {
            this.ownerHash = ownerHash;
            this.channelName = channelName;
        }

        public boolean isOurGroup() {
            return this.ownerHash == null;
        }
    }

    public static class ProfileManagerEvent {
        public final EventType type;
        @Nullable
        public final Object data;

        public ProfileManagerEvent(EventType type, @Nullable Object data) {
            this.type = type;
            this.data = data;
        }
    }

    public static class FriendRequest {
        public final Profile user;
        public final String friendCode;
        public final String desiredName;

        public FriendRequest(Profile user, String friendCode, String desiredName) {
            this.user = user;
            this.friendCode = friendCode;
            this.desiredName = desiredName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FriendRequest that = (FriendRequest)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.friendCode, that.friendCode) && Objects.equals(this.desiredName, that.desiredName);
        }

        public int hashCode() {
            return Objects.hash(this.user, this.friendCode, this.desiredName);
        }
    }
}

