/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.irc.pircbotx.event;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Listener;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers.AbstractListenerManager;

public class SingleThreadedListenerManager
extends AbstractListenerManager {
    private final Set<Listener> listeners = ConcurrentHashMap.newKeySet();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    @Override
    public void onEvent(Event event) {
        super.onEvent(event);
        for (Listener listener : this.listeners) {
            this.executor.submit(() -> this.executeListener(listener, event));
        }
    }

    @Override
    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public boolean listenerExists(Listener listener) {
        return this.listeners.contains(listener);
    }

    @Override
    public ImmutableSet<Listener> getListeners() {
        return ImmutableSet.copyOf(this.listeners);
    }

    @Override
    public void shutdown(PircBotX bot) {
    }
}

