/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.web;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.lib.web.ApiRequest;

public class GetConnectServersRequest
extends ApiRequest<List<ConnectServer>> {
    public static final Type LIST_SERVERS = new TypeToken<List<ConnectServer>>(){}.getType();

    public GetConnectServersRequest() {
        super("GET", "https://dist.creeper.host/MineTogether/nodesv2.json", LIST_SERVERS);
    }

    public static class ConnectServer {
        public String name;
        public String location;
        public String address;
        public int port;
        public List<String> publicKey;

        public static ConnectServer getLocalHost() {
            ConnectServer server = new ConnectServer();
            server.name = "localhost";
            server.location = "localhost";
            server.address = "localhost";
            server.port = 8443;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(ConnectServer.class.getResourceAsStream("/dev-pub.pem"), StandardCharsets.UTF_8));){
                server.publicKey = reader.lines().collect(Collectors.toList());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return server;
        }
    }
}

