/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.creeperhost.minetogether.connect.lib.netty.DataUtils;
import net.creeperhost.minetogether.connect.lib.netty.PacketCtx;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import net.creeperhost.minetogether.connect.lib.netty.packet.ServerPacketHandler;

public final class SHello
implements Packet<ServerPacketHandler> {
    public final byte[] nonce;
    public final byte[] encryptedAESKey;
    public final int protocolVersion;

    public SHello(byte[] nonce, byte[] encryptedAESKey, int protocolVersion) {
        this.nonce = nonce;
        this.encryptedAESKey = encryptedAESKey;
        this.protocolVersion = protocolVersion;
    }

    public SHello(PacketCtx ctx) {
        this.nonce = DataUtils.readBytes(ctx.buf);
        this.encryptedAESKey = DataUtils.readBytes(ctx.buf);
        this.protocolVersion = ctx.buf.readableBytes() > 0 ? DataUtils.readVarInt(ctx.buf) : 0;
    }

    @Override
    public void write(ByteBuf buf) {
        DataUtils.writeBytes(buf, this.nonce);
        DataUtils.writeBytes(buf, this.encryptedAESKey);
        DataUtils.writeVarInt(buf, this.protocolVersion);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, ServerPacketHandler handler) throws Exception {
        handler.handleHello(ctx, this);
    }
}

