/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.creeperhost.minetogether.connect.lib.netty.PacketCtx;
import net.creeperhost.minetogether.connect.lib.netty.packet.CAccepted;
import net.creeperhost.minetogether.connect.lib.netty.packet.CBeginRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.CDisconnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.CFriendServers;
import net.creeperhost.minetogether.connect.lib.netty.packet.CHello;
import net.creeperhost.minetogether.connect.lib.netty.packet.CMessage;
import net.creeperhost.minetogether.connect.lib.netty.packet.CPong;
import net.creeperhost.minetogether.connect.lib.netty.packet.CRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.CServerLink;
import net.creeperhost.minetogether.connect.lib.netty.packet.MDisconnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.MEncrypt;
import net.creeperhost.minetogether.connect.lib.netty.packet.MHello;
import net.creeperhost.minetogether.connect.lib.netty.packet.MHostUpdate;
import net.creeperhost.minetogether.connect.lib.netty.packet.MHostingElsewhere;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import net.creeperhost.minetogether.connect.lib.netty.packet.Ping;
import net.creeperhost.minetogether.connect.lib.netty.packet.Pong;
import net.creeperhost.minetogether.connect.lib.netty.packet.SAccepted;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHello;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHostConnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHostRegister;
import net.creeperhost.minetogether.connect.lib.netty.packet.SMeshConnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.SPing;
import net.creeperhost.minetogether.connect.lib.netty.packet.SRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.SRequestFriendServers;
import net.creeperhost.minetogether.connect.lib.netty.packet.SUserConnect;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.SneakyUtils;

public class PacketType {
    private static final List<PacketHandle<?>> HANDLES = new ArrayList();
    private static final Map<Class<? extends Packet<?>>, PacketHandle<?>> HANDLE_LOOKUP = new HashMap();
    private static final Map<Class<? extends Packet<?>>, Integer> ID_LOOKUP = new HashMap();
    private static final Map<Integer, Function<PacketCtx, ? extends Packet<?>>> FACTORY_LOOKUP = new HashMap();

    private static <C extends Packet<?>> void addHandle(int id, Class<C> packetClass, Function<PacketCtx, C> factory) {
        PacketType.addHandle(id, packetClass, factory, 0);
    }

    private static <C extends Packet<?>> void addHandle(int id, Class<C> packetClass, Function<PacketCtx, C> factory, int requiredProtocol) {
        PacketType.addHandle(new PacketHandle<C>(id, packetClass, factory, requiredProtocol));
    }

    private static void addHandle(PacketHandle<?> handle) {
        HANDLES.add(handle);
        if (!Modifier.isFinal(handle.packetClass.getModifiers())) {
            throw new IllegalArgumentException("Packet class " + handle.packetClass.getName() + " should be final.");
        }
        if (FACTORY_LOOKUP.containsKey(handle.id)) {
            throw new IllegalArgumentException("Packet with id " + handle.id + " already registered.");
        }
        ID_LOOKUP.put(handle.packetClass, handle.id);
        HANDLE_LOOKUP.put(handle.packetClass, handle);
        FACTORY_LOOKUP.put(handle.id, handle.factory);
    }

    public static <P extends Packet<?>> PacketHandle<P> getPacketHandle(P packet) {
        PacketHandle<?> handle = HANDLE_LOOKUP.get(packet.getClass());
        if (handle == null) {
            throw new IllegalArgumentException("Unregistered packet class: " + packet.getClass().getName());
        }
        return (PacketHandle)SneakyUtils.unsafeCast(handle);
    }

    public static Function<PacketCtx, ? extends Packet<?>> getPacketFactory(int id) {
        Function<PacketCtx, ? extends Packet<?>> factory = FACTORY_LOOKUP.get(id);
        if (factory == null) {
            throw new IllegalArgumentException("Unregistered packet id: " + id);
        }
        return factory;
    }

    static {
        PacketType.addHandle(40, Ping.class, Ping::new, 3);
        PacketType.addHandle(41, Pong.class, Pong::new, 3);
        PacketType.addHandle(0, CHello.class, CHello::new);
        PacketType.addHandle(1, CFriendServers.class, CFriendServers::new);
        PacketType.addHandle(2, CDisconnect.class, CDisconnect::new);
        PacketType.addHandle(3, CAccepted.class, CAccepted::new);
        PacketType.addHandle(4, CServerLink.class, CServerLink::new);
        PacketType.addHandle(5, CBeginRaw.class, CBeginRaw::new);
        PacketType.addHandle(6, CRaw.class, CRaw::new);
        PacketType.addHandle(7, CPong.class, CPong::new);
        PacketType.addHandle(30, CMessage.class, CMessage::new, 4);
        PacketType.addHandle(8, SHello.class, SHello::new);
        PacketType.addHandle(9, SRequestFriendServers.class, SRequestFriendServers::new);
        PacketType.addHandle(10, SHostRegister.class, SHostRegister::new);
        PacketType.addHandle(11, SHostConnect.class, SHostConnect::new);
        PacketType.addHandle(12, SUserConnect.class, SUserConnect::new);
        PacketType.addHandle(13, SMeshConnect.class, SMeshConnect::new);
        PacketType.addHandle(14, SRaw.class, SRaw::new);
        PacketType.addHandle(15, SPing.class, SPing::new);
        PacketType.addHandle(50, SAccepted.class, SAccepted::new);
        PacketType.addHandle(16, MHello.class, MHello::new);
        PacketType.addHandle(17, MDisconnect.class, MDisconnect::new);
        PacketType.addHandle(18, MEncrypt.class, MEncrypt::new);
        PacketType.addHandle(21, MHostUpdate.class, MHostUpdate::new);
        PacketType.addHandle(22, MHostingElsewhere.class, MHostingElsewhere::new);
    }

    public static class PacketHandle<C extends Packet<?>> {
        public final int id;
        public final Class<C> packetClass;
        public final Function<PacketCtx, C> factory;
        public final int requiresVersion;

        public PacketHandle(int id, Class<C> packetClass, Function<PacketCtx, C> factory, int requiresVersion) {
            this.id = id;
            this.packetClass = packetClass;
            this.factory = factory;
            this.requiresVersion = requiresVersion;
        }
    }
}

