/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import net.creeperhost.minetogether.connect.lib.netty.DataUtils;

public class FrameCodec
extends ByteToMessageCodec<ByteBuf> {
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        int wIndex = out.writerIndex();
        int readableBytes = msg.readableBytes();
        DataUtils.writeVarInt(out, readableBytes);
        out.writeBytes(msg, msg.readerIndex(), readableBytes);
        this.bytesWritten(out.writerIndex() - wIndex);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        in.markReaderIndex();
        int rIndex = in.readerIndex();
        for (int i = 0; i < 5 && (in.readByte() & 0x80) == 128; ++i) {
            if (in.isReadable()) continue;
            in.resetReaderIndex();
            return;
        }
        in.resetReaderIndex();
        int frameLen = DataUtils.readVarInt(in);
        if (in.readableBytes() < frameLen) {
            in.resetReaderIndex();
            return;
        }
        out.add(in.readBytes(frameLen));
        this.bytesRead(in.readerIndex() - rIndex);
    }

    protected void bytesWritten(int bytes) {
    }

    protected void bytesRead(int bytes) {
    }
}

