/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.httpclient.multipart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.multipart.BodyPartPayload;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.multipart.ByteArrayBodyPartPayload;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.multipart.FileByteArrayBodyPartPayload;

public class MultipartPayload
extends BodyPartPayload {
    private static final String B_CHARS_NO_SPACE_PATTERN = "0-9a-zA-Z'()+_,-./:=?";
    private static final String B_CHARS_PATTERN = "0-9a-zA-Z'()+_,-./:=? ";
    private static final String BOUNDARY_PATTERN = "[0-9a-zA-Z'()+_,-./:=? ]{0,69}[0-9a-zA-Z'()+_,-./:=?]";
    private static final Pattern BOUNDARY_REGEXP = Pattern.compile("[0-9a-zA-Z'()+_,-./:=? ]{0,69}[0-9a-zA-Z'()+_,-./:=?]");
    private static final Pattern BOUNDARY_FROM_HEADER_REGEXP = Pattern.compile("; boundary=\"?([0-9a-zA-Z'()+_,-./:=? ]{0,69}[0-9a-zA-Z'()+_,-./:=?])\"?");
    private static final String DEFAULT_SUBTYPE = "form-data";
    private final String boundary;
    private String preamble;
    private final List<BodyPartPayload> bodyParts = new ArrayList<BodyPartPayload>();
    private String epilogue;

    public MultipartPayload() {
        this(null, MultipartPayload.generateDefaultBoundary(), null);
    }

    public MultipartPayload(String boundary) {
        this(null, boundary, null);
    }

    public MultipartPayload(String subtype, String boundary) {
        this(subtype, boundary, null);
    }

    public MultipartPayload(Map<String, String> headers) {
        this(null, MultipartPayload.parseOrGenerateBoundary(headers), headers);
    }

    public MultipartPayload(String boundary, Map<String, String> headers) {
        this(null, boundary, headers);
    }

    public MultipartPayload(String subtype, String boundary, Map<String, String> headers) {
        super(MultipartPayload.composeHeaders(subtype, boundary, headers));
        this.boundary = boundary;
    }

    private static Map<String, String> composeHeaders(String subtype, String boundary, Map<String, String> headersIn) throws IllegalArgumentException {
        Map<String, String> headersOut;
        String contentTypeHeader;
        MultipartPayload.checkBoundarySyntax(boundary);
        String string = contentTypeHeader = headersIn == null ? null : headersIn.get("Content-Type");
        if (contentTypeHeader == null) {
            contentTypeHeader = "multipart/" + (subtype == null ? DEFAULT_SUBTYPE : subtype) + "; boundary=\"" + boundary + '\"';
            if (headersIn == null) {
                headersOut = Collections.singletonMap("Content-Type", contentTypeHeader);
            } else {
                headersOut = headersIn;
                headersOut.put("Content-Type", contentTypeHeader);
            }
        } else {
            headersOut = headersIn;
            String parsedBoundary = MultipartPayload.parseBoundaryFromHeader(contentTypeHeader);
            if (parsedBoundary == null) {
                headersOut.put("Content-Type", contentTypeHeader + "; boundary=\"" + boundary + '\"');
            } else if (!parsedBoundary.equals(boundary)) {
                throw new IllegalArgumentException("Different boundaries was passed in constructors. One as argument, second as header");
            }
        }
        return headersOut;
    }

    static void checkBoundarySyntax(String boundary) {
        if (boundary == null || !BOUNDARY_REGEXP.matcher(boundary).matches()) {
            throw new IllegalArgumentException("{'boundary'='" + boundary + "'} has invaid syntax. Should be '" + BOUNDARY_PATTERN + "'.");
        }
    }

    private static String parseOrGenerateBoundary(Map<String, String> headers) {
        String parsedBoundary = MultipartPayload.parseBoundaryFromHeader(headers.get("Content-Type"));
        return parsedBoundary == null ? MultipartPayload.generateDefaultBoundary() : parsedBoundary;
    }

    private static String generateDefaultBoundary() {
        return "----ScribeJava----" + System.currentTimeMillis();
    }

    static String parseBoundaryFromHeader(String contentTypeHeader) {
        if (contentTypeHeader == null) {
            return null;
        }
        Matcher matcher = BOUNDARY_FROM_HEADER_REGEXP.matcher(contentTypeHeader);
        return matcher.find() ? matcher.group(1) : null;
    }

    public void addFileBodyPart(byte[] fileContent) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(fileContent));
    }

    public void addFileBodyPart(byte[] fileContent, String name) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(fileContent, name));
    }

    public void addFileBodyPart(byte[] fileContent, String name, String filename) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(fileContent, name, filename));
    }

    public void addFileBodyPart(String contentType, byte[] fileContent) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(contentType, fileContent));
    }

    public void addFileBodyPart(String contentType, byte[] fileContent, String name) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(contentType, fileContent, name));
    }

    public void addFileBodyPart(String contentType, byte[] fileContent, String name, String filename) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(contentType, fileContent, name, filename));
    }

    public void addBodyPart(BodyPartPayload bodyPartPayload) {
        this.bodyParts.add(bodyPartPayload);
    }

    public void addBodyPart(MultipartPayload multipartPayload) {
        if (multipartPayload.getBoundary().equals(this.boundary)) {
            throw new IllegalArgumentException("{'boundary'}={'" + this.boundary + "'} is the same for parent MultipartPayload and child");
        }
        this.bodyParts.add(multipartPayload);
    }

    public void addBodyPart(byte[] bodyPartPayload) {
        this.addBodyPart(new ByteArrayBodyPartPayload(bodyPartPayload));
    }

    public void addBodyPart(byte[] bodyPartPayload, String contentType) {
        this.addBodyPart(new ByteArrayBodyPartPayload(bodyPartPayload, contentType));
    }

    public void addBodyPart(byte[] bodyPartPayload, Map<String, String> headers) {
        this.addBodyPart(new ByteArrayBodyPartPayload(bodyPartPayload, headers));
    }

    public List<BodyPartPayload> getBodyParts() {
        return this.bodyParts;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public String getEpilogue() {
        return this.epilogue;
    }

    public void setEpilogue(String epilogue) {
        this.epilogue = epilogue;
    }
}

