/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.extractors;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.com.github.scribejava.core.exceptions.OAuthException;
import net.creeperhost.minetogether.com.github.scribejava.core.extractors.TokenExtractor;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth1Token;
import net.creeperhost.minetogether.com.github.scribejava.core.model.Response;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.OAuthEncoder;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.Preconditions;

public abstract class AbstractOAuth1TokenExtractor<T extends OAuth1Token>
implements TokenExtractor<T> {
    private static final Pattern OAUTH_TOKEN_REGEXP_PATTERN = Pattern.compile("oauth_token=([^&]+)");
    private static final Pattern OAUTH_TOKEN_SECRET_REGEXP_PATTERN = Pattern.compile("oauth_token_secret=([^&]*)");

    @Override
    public T extract(Response response) throws IOException {
        String body = response.getBody();
        Preconditions.checkEmptyString(body, "Response body is incorrect. Can't extract a token from an empty string");
        String token = this.extract(body, OAUTH_TOKEN_REGEXP_PATTERN);
        String secret = this.extract(body, OAUTH_TOKEN_SECRET_REGEXP_PATTERN);
        return this.createToken(token, secret, body);
    }

    private String extract(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return OAuthEncoder.decode(matcher.group(1));
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + response + "'", null);
    }

    protected abstract T createToken(String var1, String var2, String var3);
}

