/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.apis;

import java.io.OutputStream;
import net.creeperhost.minetogether.com.github.scribejava.apis.facebook.FacebookAccessTokenJsonExtractor;
import net.creeperhost.minetogether.com.github.scribejava.apis.facebook.FacebookService;
import net.creeperhost.minetogether.com.github.scribejava.core.builder.api.DefaultApi20;
import net.creeperhost.minetogether.com.github.scribejava.core.extractors.TokenExtractor;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.HttpClient;
import net.creeperhost.minetogether.com.github.scribejava.core.httpclient.HttpClientConfig;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth2AccessToken;
import net.creeperhost.minetogether.com.github.scribejava.core.model.Verb;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth2.clientauthentication.ClientAuthentication;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth2.clientauthentication.RequestBodyAuthenticationScheme;

public class FacebookApi
extends DefaultApi20 {
    private final String version;

    protected FacebookApi() {
        this("3.2");
    }

    protected FacebookApi(String version) {
        this.version = version;
    }

    public static FacebookApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static FacebookApi customVersion(String version) {
        return new FacebookApi(version);
    }

    @Override
    public Verb getAccessTokenVerb() {
        return Verb.GET;
    }

    @Override
    public String getAccessTokenEndpoint() {
        return "https://graph.facebook.com/v" + this.version + "/oauth/access_token";
    }

    @Override
    public String getRefreshTokenEndpoint() {
        throw new UnsupportedOperationException("Facebook doesn't support refreshing tokens");
    }

    @Override
    protected String getAuthorizationBaseUrl() {
        return "https://www.facebook.com/v" + this.version + "/dialog/oauth";
    }

    @Override
    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return FacebookAccessTokenJsonExtractor.instance();
    }

    @Override
    public ClientAuthentication getClientAuthentication() {
        return RequestBodyAuthenticationScheme.instance();
    }

    @Override
    public FacebookService createService(String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        return new FacebookService(this, apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    private static class InstanceHolder {
        private static final FacebookApi INSTANCE = new FacebookApi();

        private InstanceHolder() {
        }
    }
}

