/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.Map;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerIconElement
extends GuiElement<PlayerIconElement>
implements BackgroundRender {
    @Nullable
    private RenderType skinType;
    public boolean textureFail = false;
    @Nullable
    private GameProfile profile;
    private Material fallback = MTTextures.get("player_offline");

    public PlayerIconElement(@NotNull GuiParent<?> parent, @Nullable GameProfile profile) {
        super(parent);
        this.profile = profile;
    }

    public void setProfile(GameProfile profile) {
        this.profile = profile;
        this.skinType = null;
        this.textureFail = false;
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.skinType == null && this.profile != null && !this.textureFail) {
            this.updateGameProfile();
        }
        if (this.skinType != null) {
            this.draw(render);
        } else {
            render.texRect(this.fallback, this.getRectangle());
        }
    }

    public void draw(GuiRender render) {
        float texMin = 0.125f;
        float texMax = 0.25f;
        VertexConsumer buffer = render.buffers().m_6299_(this.skinType);
        Matrix4f mat = render.pose().m_85850_().m_85861_();
        buffer.m_85982_(mat, (float)this.xMax(), (float)this.yMax(), 0.0f).m_7421_(texMax, texMax).m_5752_();
        buffer.m_85982_(mat, (float)this.xMax(), (float)this.yMin(), 0.0f).m_7421_(texMax, texMin).m_5752_();
        buffer.m_85982_(mat, (float)this.xMin(), (float)this.yMin(), 0.0f).m_7421_(texMin, texMin).m_5752_();
        buffer.m_85982_(mat, (float)this.xMin(), (float)this.yMax(), 0.0f).m_7421_(texMin, texMax).m_5752_();
        render.flush();
    }

    private void updateGameProfile() {
        Map map;
        if (this.profile == null) {
            return;
        }
        if (!this.profile.getProperties().containsKey((Object)"textures")) {
            this.mc().m_91108_().fillProfileProperties(this.profile, true);
        }
        if ((map = this.mc().m_91109_().m_118815_(this.profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            this.skinType = GuiRender.texType((ResourceLocation)this.mc().m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
        } else {
            this.textureFail = true;
        }
    }
}

