/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FriendRequestScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Screen previous;
    @Nullable
    private final ProfileManager.FriendRequest request;
    private final Profile target;
    private final Type type;
    private Button cancelButton;
    private Button acceptButton;
    private EditBox nameBox;

    public FriendRequestScreen(Screen previous, ProfileManager.FriendRequest request) {
        this(previous, request, request.user, Type.ACCEPT);
    }

    public FriendRequestScreen(Screen previous, Profile target, Type type) {
        this(previous, null, target, type);
    }

    private FriendRequestScreen(Screen previous, @Nullable ProfileManager.FriendRequest request, Profile target, Type type) {
        super(type.title);
        this.previous = previous;
        this.request = request;
        this.target = target;
        this.type = type;
        assert (type != Type.ACCEPT || request != null);
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 180, this.f_96544_ - 50, 80, 20, (Component)Component.m_237115_((String)"minetogether:button.cancel"), e -> this.f_96541_.m_91152_(this.previous)));
        this.acceptButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 100, this.f_96544_ - 50, 80, 20, this.type.button, this::onAccept));
        String boxString = this.nameBox != null ? this.nameBox.m_94155_() : (this.target.isFriend() ? this.target.getFriendName() : this.target.getDisplayName());
        this.nameBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 10, 200, 20, (Component)Component.m_237119_()));
        this.nameBox.m_94144_(boxString);
        this.acceptButton.f_93623_ = this.nameBox.m_94155_().trim().length() >= 3;
        this.nameBox.m_94178_(true);
        this.nameBox.m_94190_(false);
    }

    public boolean m_5534_(char c, int i) {
        boolean ret = super.m_5534_(c, i);
        if (this.nameBox.m_93696_()) {
            this.acceptButton.f_93623_ = this.nameBox.m_94155_().trim().length() >= 3;
        }
        return ret;
    }

    public boolean m_7933_(int i, int j, int k) {
        boolean ret = super.m_7933_(i, j, k);
        if (this.nameBox.m_93696_()) {
            this.acceptButton.f_93623_ = this.nameBox.m_94155_().trim().length() >= 3;
        }
        return ret;
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_96626_(1);
        super.m_6305_(poseStack, i, j, f);
        FriendRequestScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)this.type.title, (int)(this.f_96543_ / 2), (int)5, (int)-1);
        FriendRequestScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)this.type.desc, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 30), (int)-1);
    }

    private void onAccept(Button b) {
        if (MineTogetherChat.CHAT_STATE.ircClient.getState() == IrcState.CONNECTED) {
            ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
            if (this.type == Type.REQUEST) {
                if (this.target.hasFriendCode()) {
                    profileManager.sendFriendRequest(this.target.getFriendCode(), this.nameBox.m_94155_().trim(), success -> MineTogetherChat.simpleToast((Component)Component.m_237115_((String)(success != false ? "minetogether:gui.friends.request_sent" : "minetogether:gui.friends.request_fail"))));
                } else {
                    MineTogetherChat.simpleToast((Component)Component.m_237113_((String)"Error, Profile Incomplete").m_130940_(ChatFormatting.RED));
                }
            } else if (this.type == Type.ACCEPT) {
                assert (this.request != null);
                profileManager.acceptFriendRequest(this.request, this.nameBox.m_94155_().trim());
            } else {
                assert (this.type == Type.UPDATE);
                LOGGER.fatal("Not currently implemented!");
            }
        } else {
            LOGGER.warn("IRC not connected. Did nothing.");
        }
        Minecraft.m_91087_().m_91152_(this.previous);
    }

    public static enum Type {
        REQUEST((Component)Component.m_237115_((String)"minetogether:screen.friendreq.title.request"), (Component)Component.m_237115_((String)"minetogether:screen.friendreq.button.request"), (Component)Component.m_237115_((String)"minetogether:screen.friendreq.desc.request")),
        ACCEPT((Component)Component.m_237115_((String)"minetogether:screen.friendreq.title.accept"), (Component)Component.m_237115_((String)"minetogether:screen.friendreq.button.accept"), (Component)Component.m_237115_((String)"minetogether:screen.friendreq.desc.accept")),
        UPDATE((Component)Component.m_237115_((String)"minetogether:screen.friendreq.title.update"), (Component)Component.m_237115_((String)"minetogether:screen.friendreq.button.update"), (Component)Component.m_237115_((String)"minetogether:screen.friendreq.desc.update"));

        private final Component title;
        private final Component button;
        private final Component desc;

        private Type(Component title, Component button, Component desc) {
            this.title = title;
            this.button = button;
            this.desc = desc;
        }
    }
}

