/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import net.creeperhost.minetogether.chat.MessageDropdownOption;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.MessageElement;
import net.creeperhost.minetogether.gui.PreviewElement;
import net.creeperhost.minetogether.gui.dialogs.ContextMenu;
import net.creeperhost.minetogether.gui.dialogs.TextInputDialog;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatScreenInjection
implements GuiProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private static PreviewElement.URLProvider linkProvider;
    private ModularGui gui;
    @Nullable
    private ContextMenu activeMenu;
    @Nullable
    private PreviewElement preview;

    public GuiElement<?> createRootElement(ModularGui gui) {
        return new PaddedRoot((GuiParent<?>)gui);
    }

    public void buildGui(ModularGui gui) {
        this.gui = gui;
        gui.initFullscreenGui();
        this.preview = new PreviewElement((GuiParent<?>)gui.getRoot());
        Constraints.bind((ConstrainedGeometry)this.preview, (ConstrainedGeometry)gui.getRoot());
        this.preview.setUrlProvider((mouseX, mouseY) -> linkProvider == null ? null : linkProvider.getUrlUnderMouse(mouseX, mouseY));
    }

    public static void setURLProvider(PreviewElement.URLProvider linkProvider) {
        ChatScreenInjection.linkProvider = linkProvider;
    }

    public boolean canShowDialog() {
        return this.activeMenu == null || !this.gui.getRoot().getChildren().contains((Object)this.activeMenu);
    }

    public void openMessageDialog(Message message, EditBox input, double mouseX, double mouseY) {
        this.activeMenu = new ContextMenu((GuiParent<?>)this.gui.getRoot());
        this.activeMenu.addTitle((Component)Component.m_237113_((String)message.senderName.getMessage()).m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD}));
        block5: for (MessageDropdownOption value : MessageDropdownOption.VALUES) {
            switch (value) {
                case MUTE: {
                    this.activeMenu.addOption((Component)value.getTitle(true).m_6881_().m_130940_(ChatFormatting.RED), message.sender::mute);
                    continue block5;
                }
                case ADD_FRIEND: {
                    this.activeMenu.addOption((Component)value.getTitle(true).m_6881_().m_130940_(ChatFormatting.AQUA), () -> {
                        ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
                        new TextInputDialog((GuiParent<?>)this.gui.getRoot(), (Component)Component.m_237115_((String)"minetogether:screen.friendreq.desc.request"), MessageElement.displayName(message.sender)).setResultCallback(friendName -> {
                            Profile target = message.sender;
                            if (!target.hasFriendCode()) {
                                LOGGER.warn("User profile incomplete, unable to send friend request at this time.");
                                MineTogetherChat.simpleToast((Component)Component.m_237113_((String)"Error, Profile Incomplete").m_130940_(ChatFormatting.RED));
                                return;
                            }
                            profileManager.sendFriendRequest(target.getFriendCode(), friendName.trim(), success -> MineTogetherChat.simpleToast((Component)Component.m_237115_((String)(success != false ? "minetogether:gui.friends.request_sent" : "minetogether:gui.friends.request_fail"))));
                        });
                    });
                    continue block5;
                }
                case MENTION: {
                    this.activeMenu.addOption((Component)value.getTitle(true).m_6881_().m_130940_(ChatFormatting.AQUA), () -> {
                        Object val = input.m_94155_();
                        if (!((String)val).isEmpty() && ((String)val).charAt(((String)val).length() - 1) != ' ') {
                            val = (String)val + " ";
                        }
                        input.m_94144_((String)val + message.sender.getDisplayName());
                    });
                }
            }
        }
        this.activeMenu.setPosition(mouseX, mouseY);
    }

    private static class PaddedRoot
    extends GuiElement<PaddedRoot>
    implements BackgroundRender {
        public PaddedRoot(@NotNull GuiParent<?> parent) {
            super(parent);
        }

        public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        }

        public double getBackgroundDepth() {
            return 105.0;
        }
    }
}

