/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.client.screen.ScreenHooks;
import dev.architectury.platform.Platform;
import java.util.Locale;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.chat.ChatAuthImpl;
import net.creeperhost.minetogether.chat.ChatStatistics;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.gui.FriendChatGui;
import net.creeperhost.minetogether.chat.gui.PublicChatGui;
import net.creeperhost.minetogether.chat.ingame.MTChatComponent;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.config.LocalConfig;
import net.creeperhost.minetogether.gui.SettingGui;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.MutedUserList;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcClient;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.polylib.gui.IconButton;
import net.creeperhost.minetogether.polylib.gui.SimpleToast;
import net.creeperhost.minetogether.polylib.gui.TooltipContainer;
import net.creeperhost.minetogether.util.ModPackInfo;
import net.creeperhost.polylib.client.modulargui.ModularGuiScreen;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MineTogetherChat {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ChatAuthImpl CHAT_AUTH = new ChatAuthImpl(Minecraft.m_91087_());
    private static final MutedUserList MUTED_USER_LIST = new MutedUserList(Platform.getGameFolder().resolve("local/minetogether/mutedusers.json"));
    public static ChatState CHAT_STATE = new ChatState(MineTogether.API, CHAT_AUTH, MUTED_USER_LIST, () -> ModPackInfo.getInfo().realName, false);
    public static ChatComponent vanillaChat;
    public static MTChatComponent publicChat;
    public static MTChatComponent groupChat;
    private static boolean hasHitLoadingScreen;

    public static void init() {
        MineTogetherChat.CHAT_STATE.logChatToConsole = Config.instance().logChatToConsole | Config.instance().debugMode;
        publicChat = new MTChatComponent(ChatTarget.PUBLIC, Minecraft.m_91087_());
        ClientGuiEvent.INIT_POST.register(MineTogetherChat::onScreenOpen);
        if (Config.instance().debugMode) {
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.info", "INFO");
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.debug", "INFO");
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.very_verbose", "true");
        }
        ChatStatistics.pollStats();
    }

    public static void initChat(Gui gui) {
        Minecraft mc = Minecraft.m_91087_();
        vanillaChat = gui.f_92988_;
        publicChat = new MTChatComponent(ChatTarget.PUBLIC, mc);
        groupChat = new MTChatComponent(ChatTarget.GROUP, mc);
        if (LocalConfig.instance().chatEnabled) {
            MineTogetherChat.CHAT_STATE.ircClient.start();
        }
        MineTogetherChat.CHAT_STATE.ircClient.addChannelListener(new IrcClient.ChannelListener(){

            @Override
            public void channelJoin(IrcChannel channel) {
                ProfileManager.PrivateGroup group;
                if (MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel() == null) {
                    return;
                }
                if (channel == MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel()) {
                    ModularGuiScreen mgui;
                    GuiProvider guiProvider;
                    publicChat.attach(channel);
                    Screen screen = Minecraft.m_91087_().f_91080_;
                    if (screen instanceof ModularGuiScreen && (guiProvider = (mgui = (ModularGuiScreen)screen).getModularGui().getProvider()) instanceof PublicChatGui) {
                        PublicChatGui chat = (PublicChatGui)guiProvider;
                        chat.chatMonitor.attach(channel);
                    }
                }
                if ((group = MineTogetherChat.CHAT_STATE.profileManager.getPrivateGroup()) != null && group.channelName.equals(channel.getName())) {
                    groupChat.attach(channel);
                }
            }

            @Override
            public void channelLeave(IrcChannel channel) {
            }
        });
        MineTogetherChat.CHAT_STATE.profileManager.addListener(mc, (m, e) -> m.m_18707_(() -> {
            if (e.type == ProfileManager.EventType.FRIEND_REQUEST_ADDED) {
                ProfileManager.FriendRequest fr = (ProfileManager.FriendRequest)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)Component.m_237110_((String)"minetogether:toast.fiend_request_received", (Object[])new Object[]{MineTogetherChat.displayName(fr.user)}), (Component)Component.m_237119_(), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_REQUEST_ACCEPTED) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)Component.m_237110_((String)"minetogether:toast.fiend_request_accepted", (Object[])new Object[]{MineTogetherChat.displayName(fr)}), (Component)Component.m_237119_(), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_ONLINE && LocalConfig.instance().friendNotifications) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)Component.m_237110_((String)"minetogether:toast.user_online", (Object[])new Object[]{MineTogetherChat.displayName(fr)}), (Component)Component.m_237119_(), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_OFFLINE && LocalConfig.instance().friendNotifications) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)Component.m_237110_((String)"minetogether:toast.user_offline", (Object[])new Object[]{MineTogetherChat.displayName(fr)}), (Component)Component.m_237119_(), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.GROUP_INVITE_RECEIVED) {
                ProfileManager.PrivateGroup group = (ProfileManager.PrivateGroup)e.data;
                if (group != null && group.ownerHash != null) {
                    Profile sender = MineTogetherChat.CHAT_STATE.profileManager.lookupProfile(group.ownerHash);
                    MineTogetherChat.addToast(new SimpleToast((Component)Component.m_237110_((String)"minetogether:toast.group_invite_received", (Object[])new Object[]{MineTogetherChat.displayName(sender)}), (Component)Component.m_237119_(), Constants.MINETOGETHER_LOGO_25));
                }
            } else if (e.type == ProfileManager.EventType.LEFT_GROUP) {
                if (MineTogetherChat.getTarget() == ChatTarget.GROUP) {
                    MineTogetherChat.setTarget(ChatTarget.VANILLA);
                }
                MineTogetherChat.addToast(new SimpleToast((Component)Component.m_237115_((String)"minetogether:toast.left_group"), (Component)Component.m_237115_((String)("minetogether:toast.left_group." + e.data)), Constants.MINETOGETHER_LOGO_25));
            }
        }));
        String lowerHash = CHAT_AUTH.getHash().toLowerCase(Locale.ROOT);
        if (!LocalConfig.instance().firstConnect.contains(lowerHash) && MineTogetherChat.CHAT_STATE.profileManager.getOwnProfile().hasAccount()) {
            LocalConfig.instance().firstConnect.add(lowerHash);
            LocalConfig.save();
        }
    }

    public static void simpleToast(Component toastText) {
        MineTogetherChat.addToast(new SimpleToast(toastText, (Component)Component.m_237119_(), Constants.MINETOGETHER_LOGO_25));
    }

    public static void simpleToast(Component toastTitle, Component toastText) {
        MineTogetherChat.addToast(new SimpleToast(toastTitle, toastText, Constants.MINETOGETHER_LOGO_25));
    }

    private static void addToast(Toast toast) {
        if (hasHitLoadingScreen) {
            Minecraft.m_91087_().m_91300_().m_94922_(toast);
        }
    }

    public static Profile getOurProfile() {
        return MineTogetherChat.CHAT_STATE.profileManager.getOwnProfile();
    }

    private static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        if (screen instanceof TitleScreen) {
            if (!hasHitLoadingScreen) {
                hasHitLoadingScreen = true;
            }
            if (LocalConfig.instance().mainMenuButtons) {
                MineTogetherChat.addMenuButtons(screen);
            }
        } else if (screen instanceof PauseScreen && Config.instance().pauseScreenButtons) {
            MineTogetherChat.addMenuButtons(screen);
        }
    }

    private static void addMenuButtons(Screen screen) {
        int buttonPos = 4;
        TooltipContainer tooltips = new TooltipContainer(screen);
        IconButton settings = new IconButton(screen.f_96543_ - (buttonPos += 21), 5, 3, Constants.WIDGETS_SHEET, e -> Minecraft.m_91087_().m_91152_((Screen)new SettingGui.Screen(screen)));
        ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)settings);
        tooltips.addTooltip(settings, (Component)Component.m_237115_((String)"minetogether:gui.button.settings.info"));
        IconButton friendChat = new IconButton(screen.f_96543_ - (buttonPos += 21), 5, 7, Constants.WIDGETS_SHEET, e -> Minecraft.m_91087_().m_91152_((Screen)new FriendChatGui.Screen(screen)));
        ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)friendChat);
        tooltips.addTooltip(friendChat, (Component)Component.m_237115_((String)"minetogether:gui.button.friends.info"));
        if (LocalConfig.instance().chatEnabled) {
            IconButton publicChat = new IconButton(screen.f_96543_ - (buttonPos += 21), 5, 1, Constants.WIDGETS_SHEET, e -> Minecraft.m_91087_().m_91152_((Screen)new PublicChatGui.Screen(screen)));
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)publicChat);
            tooltips.addTooltip(publicChat, (Component)Component.m_237115_((String)"minetogether:gui.button.global_chat.info"));
        }
        ScreenHooks.addRenderableOnly((Screen)screen, (Widget)tooltips);
    }

    public static boolean isNewUser() {
        if (MineTogetherChat.getOurProfile().hasAccount()) {
            return false;
        }
        return !LocalConfig.instance().firstConnect.contains(CHAT_AUTH.getHash().toLowerCase(Locale.ROOT));
    }

    public static void setNewUserResponded() {
        LocalConfig.instance().firstConnect.add(CHAT_AUTH.getHash().toLowerCase(Locale.ROOT));
        LocalConfig.save();
    }

    public static void disableChat() {
        MineTogetherChat.CHAT_STATE.ircClient.stop();
    }

    public static void enableChat() {
        MineTogetherChat.CHAT_STATE.ircClient.start();
    }

    public static void setTarget(ChatTarget target) {
        LocalConfig.instance().selectedTab = target;
        LocalConfig.save();
    }

    public static ChatTarget getTarget() {
        return LocalConfig.instance().chatEnabled ? LocalConfig.instance().selectedTab : ChatTarget.VANILLA;
    }

    public static String displayName(@Nullable Profile profile) {
        return profile == null ? "" : (profile.isFriend() && profile.hasFriendName() ? profile.getFriendName() : profile.getDisplayName());
    }

    static {
        hasHitLoadingScreen = false;
    }
}

