/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import dev.architectury.event.events.client.ClientTickEvent;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.config.LocalConfig;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.irc.IrcUser;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class FriendChatNotifier {
    private static final UUID MESSAGE_SIG_ID = UUID.fromString("62a8d597-ace8-4485-8917-a3cce82b6147");
    private static int tick = 0;
    private static final Map<Profile, Integer> LAST_MESSAGE_COUNT = new HashMap<Profile, Integer>();
    private static final Map<Profile, Integer> UNREAD_MESSAGES_COUNT = new HashMap<Profile, Integer>();
    @Nullable
    private static Profile activeChat = null;

    public static void init() {
        ClientTickEvent.CLIENT_PRE.register(FriendChatNotifier::tick);
    }

    private static void tick(Minecraft mc) {
        if (tick++ % 20 == 0) {
            return;
        }
        ChatState chatState = MineTogetherChat.CHAT_STATE;
        ProfileManager profileManager = chatState.profileManager;
        HashSet<Profile> friends = FastStream.of(profileManager.getKnownProfiles()).filter(Profile::isFriend).filter(Profile::isOnline).toSet();
        LAST_MESSAGE_COUNT.entrySet().removeIf(e -> !((Profile)e.getKey()).isFriend());
        UNREAD_MESSAGES_COUNT.entrySet().removeIf(e -> !((Profile)e.getKey()).isFriend());
        for (Profile friend : friends) {
            int lastMessageCount;
            int messageCount;
            IrcUser user = chatState.ircClient.getUser(friend);
            if (user == null || (messageCount = user.getChannel().getMessages().size()) <= (lastMessageCount = LAST_MESSAGE_COUNT.getOrDefault(friend, 0).intValue())) continue;
            int lastUnreadCount = UNREAD_MESSAGES_COUNT.getOrDefault(friend, 0);
            int newUnreadCount = lastUnreadCount + (messageCount - lastMessageCount);
            if (activeChat == friend) {
                newUnreadCount = 0;
            }
            UNREAD_MESSAGES_COUNT.put(friend, newUnreadCount);
            LAST_MESSAGE_COUNT.put(friend, messageCount);
            if (newUnreadCount <= 0) continue;
            FriendChatNotifier.notifyMessageReceived(friend, newUnreadCount, lastUnreadCount);
        }
    }

    private static void notifyMessageReceived(Profile profile, int unreadCount, int lastUnreadCount) {
        if (lastUnreadCount == 0 && LocalConfig.instance().friendNotifications && activeChat == null) {
            String name = profile.hasFriendName() ? profile.getFriendName() : profile.getDisplayName();
            MineTogetherChat.simpleToast((Component)Component.m_237110_((String)"minetogether:toast.friend_message", (Object[])new Object[]{name}));
            MutableComponent message = Component.m_237110_((String)"minetogether:chat.friend_message", (Object[])new Object[]{Component.m_237113_((String)name).m_130940_(ChatFormatting.GOLD)}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"minetogether:chat.friend_message.info"))).m_131142_((ClickEvent)new OpenFriendEvent(profile)));
            FriendChatNotifier.addNotificationMessage((Component)message, FriendChatNotifier.profileToSig(profile));
        }
    }

    public static int getUnreadMessageCount(Profile profile) {
        return UNREAD_MESSAGES_COUNT.getOrDefault(profile, 0);
    }

    public static void resetUnreadMessageCount(Profile profile) {
        UNREAD_MESSAGES_COUNT.put(profile, 0);
    }

    public static void setActiveChat(@Nullable Profile activeChat) {
        FriendChatNotifier.activeChat = activeChat;
        if (activeChat != null) {
            FriendChatNotifier.resetUnreadMessageCount(activeChat);
        }
    }

    public static void addNotificationMessage(@Nullable Component message, MessageSignature signature) {
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC) {
            MineTogetherChat.publicChat.localMessage(message, signature);
        } else {
            FriendChatNotifier.deleteMessage(signature);
            if (message != null) {
                MineTogetherChat.vanillaChat.m_240964_(message, signature, null);
            }
        }
    }

    private static void deleteMessage(MessageSignature signature) {
        ListIterator listiterator = MineTogetherChat.vanillaChat.f_93760_.listIterator();
        while (listiterator.hasNext()) {
            GuiMessage guimessage = (GuiMessage)listiterator.next();
            if (!signature.equals((Object)guimessage.f_240905_())) continue;
            listiterator.remove();
            MineTogetherChat.vanillaChat.m_241120_();
        }
    }

    public static MessageSignature profileToSig(Profile target) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        byteBuffer.putLong(MESSAGE_SIG_ID.getMostSignificantBits());
        byteBuffer.putLong(MESSAGE_SIG_ID.getLeastSignificantBits());
        for (byte b : target.getFullHash().getBytes()) {
            byteBuffer.put(b);
        }
        return new MessageSignature(byteBuffer.array());
    }

    public static class OpenFriendEvent
    extends ClickEvent {
        public final Profile profile;

        public OpenFriendEvent(Profile profile) {
            super(ClickEvent.Action.RUN_COMMAND, "");
            this.profile = profile;
        }
    }
}

