/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Pair;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;

public class AllPortalTracks {
    private static final AttachedRegistry<Block, PortalTrackProvider> PORTAL_BEHAVIOURS = new AttachedRegistry(ForgeRegistries.BLOCKS);

    public static void registerIntegration(ResourceLocation block, PortalTrackProvider provider) {
        PORTAL_BEHAVIOURS.register((Block)block, provider);
    }

    public static void registerIntegration(Block block, PortalTrackProvider provider) {
        PORTAL_BEHAVIOURS.register(block, provider);
    }

    public static boolean isSupportedPortal(BlockState state) {
        return PORTAL_BEHAVIOURS.get(state.m_60734_()) != null;
    }

    public static Pair<ServerLevel, BlockFace> getOtherSide(ServerLevel level, BlockFace inboundTrack) {
        BlockPos portalPos = inboundTrack.getConnectedPos();
        BlockState portalState = level.m_8055_(portalPos);
        PortalTrackProvider provider = PORTAL_BEHAVIOURS.get(portalState.m_60734_());
        return provider == null ? null : (Pair)provider.apply(Pair.of(level, inboundTrack));
    }

    public static void registerDefaults() {
        AllPortalTracks.registerIntegration(Blocks.f_50142_, AllPortalTracks::nether);
        if (Mods.AETHER.isLoaded()) {
            AllPortalTracks.registerIntegration(new ResourceLocation("aether", "aether_portal"), AllPortalTracks::aether);
        }
    }

    private static Pair<ServerLevel, BlockFace> nether(Pair<ServerLevel, BlockFace> inbound) {
        return AllPortalTracks.standardPortalProvider(inbound, (ResourceKey<Level>)Level.f_46428_, (ResourceKey<Level>)Level.f_46429_, ServerLevel::m_8871_);
    }

    private static Pair<ServerLevel, BlockFace> aether(Pair<ServerLevel, BlockFace> inbound) {
        ResourceKey aetherLevelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("aether", "the_aether"));
        return AllPortalTracks.standardPortalProvider(inbound, (ResourceKey<Level>)Level.f_46428_, (ResourceKey<Level>)aetherLevelKey, level -> {
            try {
                return (ITeleporter)Class.forName("com.aetherteam.aether.block.portal.AetherPortalForcer").getDeclaredConstructor(ServerLevel.class, Boolean.TYPE).newInstance(level, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return level.m_8871_();
            }
        });
    }

    public static Pair<ServerLevel, BlockFace> standardPortalProvider(Pair<ServerLevel, BlockFace> inbound, ResourceKey<Level> firstDimension, ResourceKey<Level> secondDimension, Function<ServerLevel, ITeleporter> customPortalForcer) {
        ServerLevel level = inbound.getFirst();
        ResourceKey<Level> resourcekey = level.m_46472_() == secondDimension ? firstDimension : secondDimension;
        MinecraftServer minecraftserver = level.m_7654_();
        ServerLevel otherLevel = minecraftserver.m_129880_(resourcekey);
        if (otherLevel == null || !minecraftserver.m_7079_()) {
            return null;
        }
        BlockFace inboundTrack = inbound.getSecond();
        BlockPos portalPos = inboundTrack.getConnectedPos();
        BlockState portalState = level.m_8055_(portalPos);
        ITeleporter teleporter = customPortalForcer.apply(otherLevel);
        SuperGlueEntity probe = new SuperGlueEntity((Level)level, new AABB(portalPos));
        probe.m_146922_(inboundTrack.getFace().m_122435_());
        probe.setPortalEntrancePos();
        PortalInfo portalinfo = teleporter.getPortalInfo((Entity)probe, otherLevel, probe::m_7937_);
        if (portalinfo == null) {
            return null;
        }
        BlockPos otherPortalPos = new BlockPos(portalinfo.f_77676_);
        BlockState otherPortalState = otherLevel.m_8055_(otherPortalPos);
        if (otherPortalState.m_60734_() != portalState.m_60734_()) {
            return null;
        }
        Direction targetDirection = inboundTrack.getFace();
        if (targetDirection.m_122434_() == otherPortalState.m_61143_((Property)BlockStateProperties.f_61364_)) {
            targetDirection = targetDirection.m_122427_();
        }
        BlockPos otherPos = otherPortalPos.m_121945_(targetDirection);
        return Pair.of(otherLevel, new BlockFace(otherPos, targetDirection.m_122424_()));
    }

    @FunctionalInterface
    public static interface PortalTrackProvider
    extends UnaryOperator<Pair<ServerLevel, BlockFace>> {
    }
}

